/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class LoadData {
    private static Properties ini = new Properties();
    private static String db;
    private static Properties dbProps;
    private static jTPCCRandom rnd;
    private static String fileLocation;
    private static String csvNullValue;
    private static int numWarehouses;
    private static int startWarehouse;
    private static int endWarehouse;
    private static boolean useReplace;
    private static int numWorkers;
    private static int nextJob;
    private static final Object nextJobLock;
    private static LoadDataWorker[] workers;
    private static Thread[] workerThreads;
    private static String[] argv;
    public static boolean[] completedWarehouses;
    private static boolean writeCSV;
    private static BufferedWriter configCSV;
    private static BufferedWriter itemCSV;
    private static BufferedWriter warehouseCSV;
    private static BufferedWriter districtCSV;
    private static BufferedWriter stockCSV;
    private static BufferedWriter customerCSV;
    private static BufferedWriter historyCSV;
    private static BufferedWriter orderCSV;
    private static BufferedWriter orderLineCSV;
    private static BufferedWriter newOrderCSV;

    public static void main(String[] args) {
        int i;
        System.out.println("Starting BenchmarkSQL LoadData");
        System.out.println("");
        try {
            ini.load(new FileInputStream(System.getProperty("prop")));
        }
        catch (IOException e) {
            System.err.println("ERROR: " + e.getMessage());
            System.exit(1);
        }
        argv = args;
        rnd = new jTPCCRandom();
        try {
            Class.forName(LoadData.iniGetString("driver"));
        }
        catch (Exception e) {
            System.err.println("ERROR: cannot load JDBC driver - " + e.getMessage());
            System.exit(1);
        }
        db = LoadData.iniGetString("conn");
        dbProps = new Properties();
        dbProps.setProperty("user", LoadData.iniGetString("user"));
        dbProps.setProperty("password", LoadData.iniGetString("password"));
        numWarehouses = LoadData.iniGetInt("warehouses");
        startWarehouse = LoadData.iniGetInt("startWarehouse", 0);
        if (startWarehouse < 0) {
            throw new IllegalArgumentException("startWarehouse should be greater than 0");
        }
        nextJob = startWarehouse;
        endWarehouse = LoadData.iniGetInt("endWarehouse", numWarehouses);
        if (endWarehouse < startWarehouse) {
            throw new IllegalArgumentException("endWarehouse should be greater than startWarehouse");
        }
        if (startWarehouse > 0) {
            useReplace = true;
            System.out.printf("Continue from breakpoint, starts from Warehouse-%d, ends after Warehouse-%d is done.%n", startWarehouse, endWarehouse);
        }
        numWorkers = LoadData.iniGetInt("loadWorkers", 4);
        fileLocation = LoadData.iniGetString("fileLocation");
        csvNullValue = LoadData.iniGetString("csvNullValue", "NULL");
        if (startWarehouse > numWarehouses) {
            throw new IllegalArgumentException("startWarehouse: " + startWarehouse + " should be less than warehouses: " + numWarehouses);
        }
        if (fileLocation != null) {
            writeCSV = true;
            try {
                configCSV = new BufferedWriter(new FileWriter(fileLocation + "config.csv"));
                itemCSV = new BufferedWriter(new FileWriter(fileLocation + "item.csv"));
                warehouseCSV = new BufferedWriter(new FileWriter(fileLocation + "warehouse.csv"));
                districtCSV = new BufferedWriter(new FileWriter(fileLocation + "district.csv"));
                stockCSV = new BufferedWriter(new FileWriter(fileLocation + "stock.csv"));
                customerCSV = new BufferedWriter(new FileWriter(fileLocation + "customer.csv"));
                historyCSV = new BufferedWriter(new FileWriter(fileLocation + "cust-hist.csv"));
                orderCSV = new BufferedWriter(new FileWriter(fileLocation + "order.csv"));
                orderLineCSV = new BufferedWriter(new FileWriter(fileLocation + "order-line.csv"));
                newOrderCSV = new BufferedWriter(new FileWriter(fileLocation + "new-order.csv"));
            }
            catch (IOException ie) {
                System.err.println(ie.getMessage());
                System.exit(3);
            }
        }
        System.out.println("");
        workers = new LoadDataWorker[numWorkers];
        workerThreads = new Thread[numWorkers];
        completedWarehouses = new boolean[endWarehouse - startWarehouse + 1];
        for (i = 0; i < numWorkers; ++i) {
            try {
                Connection dbConn = DriverManager.getConnection(db, dbProps);
                dbConn.setAutoCommit(true);
                LoadData.workers[i] = writeCSV ? new LoadDataWorker(i, csvNullValue, rnd.newRandom()) : new LoadDataWorker(i, dbConn, rnd.newRandom(), useReplace);
                LoadData.workerThreads[i] = new Thread(workers[i]);
                workerThreads[i].start();
                continue;
            }
            catch (SQLException se) {
                System.err.println("ERROR: " + se.getMessage());
                System.exit(3);
                return;
            }
        }
        for (i = 0; i < numWorkers; ++i) {
            try {
                workerThreads[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                System.err.println("ERROR: worker " + i + " - " + ie.getMessage());
                System.exit(4);
            }
        }
        if (LoadDataWorker.stopped) {
            int warehouseID = startWarehouse - 1;
            for (boolean completed : completedWarehouses) {
                if (!completed) break;
                ++warehouseID;
            }
            System.out.println("Last completed warehouseID: " + warehouseID);
            System.exit(4);
        }
        if (writeCSV) {
            try {
                configCSV.close();
                itemCSV.close();
                warehouseCSV.close();
                districtCSV.close();
                stockCSV.close();
                customerCSV.close();
                historyCSV.close();
                orderCSV.close();
                orderLineCSV.close();
                newOrderCSV.close();
            }
            catch (IOException ie) {
                System.err.println(ie.getMessage());
                System.exit(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = configCSV;
        synchronized (bufferedWriter) {
            configCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void itemAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = itemCSV;
        synchronized (bufferedWriter) {
            itemCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warehouseAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = warehouseCSV;
        synchronized (bufferedWriter) {
            warehouseCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void districtAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = districtCSV;
        synchronized (bufferedWriter) {
            districtCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stockAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = stockCSV;
        synchronized (bufferedWriter) {
            stockCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void customerAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = customerCSV;
        synchronized (bufferedWriter) {
            customerCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void historyAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = historyCSV;
        synchronized (bufferedWriter) {
            historyCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orderAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = orderCSV;
        synchronized (bufferedWriter) {
            orderCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void orderLineAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = orderLineCSV;
        synchronized (bufferedWriter) {
            orderLineCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void newOrderAppend(StringBuffer buf) throws IOException {
        BufferedWriter bufferedWriter = newOrderCSV;
        synchronized (bufferedWriter) {
            newOrderCSV.write(buf.toString());
        }
        buf.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNextJob() {
        int job;
        Object object = nextJobLock;
        synchronized (object) {
            job = useReplace ? (nextJob > endWarehouse ? -1 : nextJob++) : (nextJob > numWarehouses ? -1 : nextJob++);
        }
        return job;
    }

    public static int getNumWarehouses() {
        return numWarehouses;
    }

    private static String iniGetString(String name) {
        String strVal = null;
        for (int i = 0; i < argv.length - 1; i += 2) {
            if (!name.toLowerCase().equals(argv[i].toLowerCase())) continue;
            strVal = argv[i + 1];
            break;
        }
        if (strVal == null) {
            strVal = ini.getProperty(name);
        }
        if (strVal == null) {
            System.out.println(name + " (not defined)");
        } else if (name.equals("password")) {
            System.out.println(name + "=***********");
        } else {
            System.out.println(name + "=" + strVal);
        }
        return strVal;
    }

    private static String iniGetString(String name, String defVal) {
        String strVal = null;
        for (int i = 0; i < argv.length - 1; i += 2) {
            if (!name.toLowerCase().equals(argv[i].toLowerCase())) continue;
            strVal = argv[i + 1];
            break;
        }
        if (strVal == null) {
            strVal = ini.getProperty(name);
        }
        if (strVal == null) {
            System.out.println(name + " (not defined - using default '" + defVal + "')");
            return defVal;
        }
        if (name.equals("password")) {
            System.out.println(name + "=***********");
        } else {
            System.out.println(name + "=" + strVal);
        }
        return strVal;
    }

    private static int iniGetInt(String name) {
        String strVal = LoadData.iniGetString(name);
        if (strVal == null) {
            return 0;
        }
        return Integer.parseInt(strVal);
    }

    private static int iniGetInt(String name, int defVal) {
        String strVal = LoadData.iniGetString(name);
        if (strVal == null) {
            return defVal;
        }
        return Integer.parseInt(strVal);
    }

    public static void completeWarehouse(int wId) {
        LoadData.completedWarehouses[wId - LoadData.startWarehouse] = true;
    }

    static {
        fileLocation = null;
        csvNullValue = null;
        useReplace = false;
        nextJob = 0;
        nextJobLock = new Object();
        writeCSV = false;
        configCSV = null;
        itemCSV = null;
        warehouseCSV = null;
        districtCSV = null;
        stockCSV = null;
        customerCSV = null;
        historyCSV = null;
        orderCSV = null;
        orderLineCSV = null;
        newOrderCSV = null;
    }
}

