/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class OSCollector {
    private String script;
    private int interval;
    private String sshAddress;
    private String devices;
    private File outputDir;
    private Logger log;
    private CollectData collector = null;
    private Thread collectorThread = null;
    private boolean endCollection = false;
    private Process collProc;
    private BufferedWriter[] resultCSVs;

    public OSCollector(String script, int runID, int interval, String sshAddress, String devices, File outputDir, Logger log) {
        ArrayList<String> cmdLine = new ArrayList<String>();
        this.script = script;
        this.interval = interval;
        this.sshAddress = sshAddress;
        this.devices = devices;
        this.outputDir = outputDir;
        this.log = log;
        if (sshAddress != null) {
            cmdLine.add("ssh");
            cmdLine.add(sshAddress);
        }
        cmdLine.add("python");
        cmdLine.add("-");
        cmdLine.add(Integer.toString(runID));
        cmdLine.add(Integer.toString(interval));
        String[] deviceNames = devices != null ? devices.split("[ \t]+") : new String[]{};
        try {
            this.resultCSVs = new BufferedWriter[deviceNames.length + 1];
            this.resultCSVs[0] = new BufferedWriter(new FileWriter(new File(outputDir, "sys_info.csv")));
            for (int i = 0; i < deviceNames.length; ++i) {
                cmdLine.add(deviceNames[i]);
                this.resultCSVs[i + 1] = new BufferedWriter(new FileWriter(new File(outputDir, deviceNames[i] + ".csv")));
            }
        }
        catch (Exception e) {
            log.error((Object)("OSCollector, " + e.getMessage()));
            System.exit(1);
        }
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(cmdLine);
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            this.collProc = pb.start();
            BufferedReader scriptReader = new BufferedReader(new FileReader(script));
            BufferedWriter scriptWriter = new BufferedWriter(new OutputStreamWriter(this.collProc.getOutputStream()));
            while ((line = scriptReader.readLine()) != null) {
                scriptWriter.write(line);
                scriptWriter.newLine();
            }
            scriptWriter.close();
            scriptReader.close();
        }
        catch (Exception e) {
            log.error((Object)("OSCollector " + e.getMessage()));
            e.printStackTrace();
            System.exit(1);
        }
        this.collector = new CollectData(this);
        this.collectorThread = new Thread(this.collector);
        this.collectorThread.start();
    }

    public void stop() {
        this.endCollection = true;
        try {
            this.collectorThread.join();
        }
        catch (InterruptedException ie) {
            this.log.error((Object)("OSCollector, " + ie.getMessage()));
            return;
        }
    }

    private class CollectData
    implements Runnable {
        private OSCollector parent;

        public CollectData(OSCollector parent) {
            this.parent = parent;
        }

        @Override
        public void run() {
            int resultIdx = 0;
            BufferedReader osData = new BufferedReader(new InputStreamReader(this.parent.collProc.getInputStream()));
            while (!OSCollector.this.endCollection || resultIdx != 0) {
                try {
                    String line = osData.readLine();
                    if (line == null) {
                        OSCollector.this.log.error((Object)"OSCollector, unexpected EOF while reading from external helper process");
                        break;
                    }
                    this.parent.resultCSVs[resultIdx].write(line);
                    this.parent.resultCSVs[resultIdx].newLine();
                    this.parent.resultCSVs[resultIdx].flush();
                    if (++resultIdx < this.parent.resultCSVs.length) continue;
                    resultIdx = 0;
                }
                catch (Exception e) {
                    OSCollector.this.log.error((Object)("OSCollector, " + e.getMessage()));
                    break;
                }
            }
            try {
                osData.close();
                for (int i = 0; i < this.parent.resultCSVs.length; ++i) {
                    this.parent.resultCSVs[i].close();
                }
            }
            catch (Exception e) {
                OSCollector.this.log.error((Object)("OSCollector, " + e.getMessage()));
            }
        }
    }
}

