/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot;

import com.polarx.benchmarkboot.exception.BaseJsonSerializeHandlerExceptionResolver;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication(exclude={SecurityAutoConfiguration.class}, scanBasePackages={"com.polarx.benchmarkboot"})
@EnableSwagger2
public class BenchmarkBootApplication {
    private static final int MIN_CORE = 4;

    @PostConstruct
    void init() {
        BenchmarkBootApplication.checkEnv();
        TimeZone.setDefault(TimeZone.getTimeZone("GMT+8"));
    }

    public static void main(String[] args) {
        SpringApplication.run(BenchmarkBootApplication.class, (String[])args);
    }

    public static void checkEnv() {
        int cores = Runtime.getRuntime().availableProcessors();
        if (cores < 4) {
            throw new RuntimeException("Local cpu cores should not be less than 4");
        }
    }

    @Bean
    public BaseJsonSerializeHandlerExceptionResolver baseJsonSerializeHandlerExceptionResolver() {
        return new BaseJsonSerializeHandlerExceptionResolver();
    }

    static {
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

