/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.LogicalDbInfo;
import com.polarx.benchmarkboot.model.dto.req.IdCompareReq;
import com.polarx.benchmarkboot.model.dto.req.IdReq;
import com.polarx.benchmarkboot.model.dto.req.MultiIdReq;
import com.polarx.benchmarkboot.model.dto.req.SwitchDbReq;
import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.SingleDbInfoRsp;
import com.polarx.benchmarkboot.model.dto.rsp.ValidateDatasetRsp;
import com.polarx.benchmarkboot.repo.DbInfoRepository;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.util.JdbcUtil;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

public abstract class BaseBenchmarkController {
    private static final Logger log = LoggerFactory.getLogger(BaseBenchmarkController.class);
    @Resource
    private DbInfoRepository dbInfoRepository;

    protected void init() {
    }

    @ApiOperation(value="\u5bfc\u5165\u538b\u6d4b\u6570\u636e")
    @PostMapping(value={"/prepare"})
    public abstract ResponseDto prepare(@NotNull @RequestBody JSONObject var1);

    @ApiOperation(value="\u8fd0\u884c\u538b\u6d4b")
    @PostMapping(value={"/run"})
    public abstract ResponseDto run(@NotNull @RequestBody JSONObject var1);

    @ApiOperation(value="\u505c\u6b62\u538b\u6d4b")
    @PostMapping(value={"/stop"})
    public abstract ResponseDto stop();

    @ApiOperation(value="\u91cd\u65b0\u8fd0\u884c\u4e0a\u4e00\u6b21")
    @PostMapping(value={"/rerun"})
    public abstract ResponseDto rerun();

    @ApiOperation(value="\u83b7\u53d6\u4e0a\u6b21\u8fd0\u884c\u53c2\u6570")
    @GetMapping(value={"/lastRunArgs"})
    public abstract ResponseDto getLastRunArgs();

    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u72b6\u6001")
    @GetMapping(value={"/status"})
    public ResponseDto<String> getBenchmarkStatus() {
        return new ResponseDto((Object)this.getBenchmarkService().getStatus().name());
    }

    @ApiOperation(value="\u5bf9\u5e94\u6570\u636e\u5e93\u4fe1\u606f")
    @GetMapping(value={"/dbInfo"})
    public abstract ResponseDto<SingleDbInfoRsp> getDbInfo();

    @ApiOperation(value="\u4e0b\u8f7d\u8fd0\u884c\u65e5\u5fd7")
    @GetMapping(value={"/result/download"})
    public String fileDownLoad(HttpServletResponse response, @ModelAttribute @Valid IdReq req) {
        ILoggedBenchmarkRunInfo runInfo = this.getRunInfoById(req.getId());
        if (runInfo == null || runInfo.getLogFilePath() == null) {
            throw new IllegalArgumentException("Log file does not exist for Task-" + req.getId());
        }
        File file = new File(runInfo.getLogFilePath());
        if (!file.exists() || !file.canRead()) {
            throw new IllegalStateException("Cannot access file: " + runInfo.getLogFilePath());
        }
        response.reset();
        response.setContentType("application/octet-stream");
        response.setCharacterEncoding("utf-8");
        response.setContentLength((int)file.length());
        response.setHeader("Content-Disposition", "attachment;filename=" + file.getName());
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            byte[] buff = new byte[1024];
            ServletOutputStream os = response.getOutputStream();
            int i = 0;
            while ((i = bis.read(buff)) != -1) {
                os.write(buff, 0, i);
                os.flush();
            }
            log.info("Downloaded log {} successfully", (Object)file.getName());
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return "Download log failed";
        }
        return "";
    }

    @ApiOperation(value="\u83b7\u53d6\u4e24\u6b21\u538b\u6d4b\u5bf9\u6bd4")
    @GetMapping(value={"/result/compare"})
    public abstract ResponseDto compareResult(@ModelAttribute @Valid IdCompareReq var1);

    @ApiOperation(value="\u5f3a\u5236\u6e05\u7a7a\u4efb\u52a1\u72b6\u6001")
    @PostMapping(value={"/setIdle"})
    public ResponseDto setIdle() {
        this.getBenchmarkService().setIdle();
        log.info("Set {} status to idle", (Object)this.getBenchmarkName());
        return new ResponseDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5207\u6362\u76ee\u6807\u6570\u636e\u5e93")
    @PostMapping(value={"/switchDb"})
    public ResponseDto switchDb(@NotNull @RequestBody @Valid SwitchDbReq req) {
        Lock writeLock = BenchmarkContext.getInstance().writeLock();
        try {
            writeLock.lock();
            BenchmarkDbInfo dbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            if (dbInfo == null) {
                throw new IllegalStateException("Database connection has not been set yet");
            }
            String dbName = req.getDbName();
            CreateDbMode createDbMode = CreateDbMode.from((String)req.getMode());
            try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)dbInfo);){
                if (createDbMode != null) {
                    JdbcUtil.createDb((Connection)conn, (String)dbName, (CreateDbMode)createDbMode);
                } else {
                    createDbMode = JdbcUtil.getDbMode((Connection)conn, (String)dbName);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e.getMessage());
            }
            this.getBenchmarkService().updateDbInfo(dbInfo, new LogicalDbInfo(dbName, createDbMode));
            this.dbInfoRepository.save((Object)dbInfo);
            log.info("Switch {} to {}, mode={}", new Object[]{this.getBenchmarkName(), dbName, createDbMode});
        }
        finally {
            writeLock.unlock();
        }
        return new ResponseDto();
    }

    @ApiOperation(value="\u6821\u9a8c\u6570\u636e\u96c6\u5b8c\u6574\u6027")
    @PostMapping(value={"/validateDataset"})
    public ResponseDto<ValidateDatasetRsp> validateDataset() {
        this.beforeCheck();
        return new ResponseDto((Object)this.getBenchmarkService().validateDataset());
    }

    @ApiOperation(value="\u83b7\u53d6\u591a\u6b21\u538b\u6d4b\u7ed3\u679c\u7684\u5bf9\u6bd4\u8868\u683c")
    @PostMapping(value={"/result/compareMulti"})
    public abstract ResponseDto compareResult(@NotNull @RequestBody @Valid MultiIdReq var1);

    @ApiOperation(value="\u5220\u9664\u7ed3\u679c\u8bb0\u5f55")
    @DeleteMapping(value={"/result"})
    public ResponseDto deleteResult(@NotNull @RequestBody @Valid MultiIdReq req) {
        this.getBenchmarkService().delete(req.getIdList());
        log.info("Deleted {} task with id: [{}]", (Object)this.getBenchmarkName(), (Object)StringUtils.join((Collection)req.getIdList(), (String)","));
        return new ResponseDto();
    }

    protected abstract ILoggedBenchmarkRunInfo getRunInfoById(Integer var1);

    protected abstract BaseBenchmarkService getBenchmarkService();

    protected abstract void beforeCheck();

    protected void beforeRunCheck() {
        this.getBenchmarkService().beforeRunCheck();
    }

    protected String getBenchmarkName() {
        return this.getBenchmarkService().getBenchmarkName();
    }

    protected RunningContext getContext() {
        return this.getBenchmarkService().getContext();
    }
}

