/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.SetGlobalHelper;
import com.polarx.benchmarkboot.model.dto.req.DatabaseInfoReq;
import com.polarx.benchmarkboot.model.dto.req.IdReq;
import com.polarx.benchmarkboot.model.dto.req.SetGlobalReq;
import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.repo.DbInfoRepository;
import com.polarx.benchmarkboot.service.IBenchmarkService;
import com.polarx.benchmarkboot.util.JdbcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u76ee\u6807\u6570\u636e\u5e93\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/config"})
public class DbConfigController {
    private static final Logger log = LoggerFactory.getLogger(DbConfigController.class);
    @Resource
    private IBenchmarkService sysbenchService;
    @Resource
    private IBenchmarkService tpccService;
    @Resource
    private IBenchmarkService tpchService;
    @Resource
    private IBenchmarkService transferService;
    @Resource
    private DbInfoRepository dbInfoRepository;
    private List<BenchmarkDbInfo> benchmarkDbInfoList;
    private final List<IBenchmarkService> benchmarkServiceList = new ArrayList();

    @PostConstruct
    public void init() {
        this.benchmarkDbInfoList = this.dbInfoRepository.findAll();
        this.benchmarkServiceList.add(this.sysbenchService);
        this.benchmarkServiceList.add(this.tpccService);
        this.benchmarkServiceList.add(this.tpchService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f")
    @PostMapping(value={"/database"})
    public synchronized ResponseDto updateDatabaseInfo(@RequestBody @Valid DatabaseInfoReq dbInfoReq) {
        Lock writeLock = BenchmarkContext.getInstance().writeLock();
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkDbInfo.from((DatabaseInfoReq)dbInfoReq);
        try {
            writeLock.lock();
            this.checkDbAndUpdateInfo(dbInfoReq, benchmarkDbInfo);
            BenchmarkDbInfo existedInfo = this.dbInfoRepository.findByHostAndPort(benchmarkDbInfo.getHost(), benchmarkDbInfo.getPort());
            if (existedInfo == null) {
                existedInfo = benchmarkDbInfo;
            } else {
                existedInfo.updateFrom(benchmarkDbInfo);
            }
            this.dbInfoRepository.save((Object)existedInfo);
            BenchmarkContext.getInstance().setBenchmarkDbInfo(existedInfo);
        }
        finally {
            writeLock.unlock();
        }
        return new ResponseDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f")
    @DeleteMapping(value={"/database"})
    @Transactional
    public ResponseDto deleteDatabaseInfo(@RequestBody @Valid IdReq req) {
        this.dbInfoRepository.deleteById(req.getId());
        Lock writeLock = BenchmarkContext.getInstance().writeLock();
        try {
            writeLock.lock();
            BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            if (benchmarkDbInfo != null && benchmarkDbInfo.getId().equals(req.getId())) {
                BenchmarkContext.getInstance().setBenchmarkDbInfo(null);
            }
        }
        finally {
            writeLock.unlock();
        }
        return new ResponseDto();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u5207\u6362\u6570\u636e\u5e93\u8fde\u63a5")
    @PostMapping(value={"/database/switch"})
    public ResponseDto switchDatabaseInfo(@RequestBody @Valid IdReq req) {
        BenchmarkDbInfo benchmarkDbInfo = this.dbInfoRepository.findById(req.getId());
        if (benchmarkDbInfo == null) {
            throw new RuntimeException("Database info does not exist");
        }
        try {
            Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)benchmarkDbInfo);
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Lock writeLock = BenchmarkContext.getInstance().writeLock();
        try {
            writeLock.lock();
            BenchmarkContext.getInstance().setBenchmarkDbInfo(benchmarkDbInfo);
            for (IBenchmarkService benchmarkService : this.benchmarkServiceList) {
                try {
                    benchmarkService.updateDbInfo(benchmarkDbInfo);
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
        }
        finally {
            writeLock.unlock();
        }
        return new ResponseDto();
    }

    @ApiOperation(value="global\u53d8\u91cf\u81ea\u52a8\u914d\u7f6e")
    @PostMapping(value={"/setGlobal"})
    public ResponseDto setGlobal(@RequestBody @Valid SetGlobalReq req) {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        if (benchmarkDbInfo == null) {
            throw new RuntimeException("Database info does not exist");
        }
        List setSqls = SetGlobalHelper.buildStmt((SetGlobalReq)req);
        if (!setSqls.isEmpty()) {
            String sql = null;
            try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)benchmarkDbInfo);
                 Statement stmt = conn.createStatement();){
                for (String s : setSqls) {
                    if (s == null) continue;
                    sql = s;
                    stmt.execute(sql);
                    log.info("Execute [{}] succeeded", (Object)sql);
                }
            }
            catch (SQLException e) {
                log.error("Failed to execute {}", sql);
                throw new RuntimeException(e);
            }
        }
        return new ResponseDto();
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f")
    @GetMapping(value={"/database/current"})
    public ResponseDto<BenchmarkDbInfo> getDatabaseInfo() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        return new ResponseDto((Object)benchmarkDbInfo);
    }

    @ApiOperation(value="\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f")
    @GetMapping(value={"/database"})
    public ResponseDto<List<BenchmarkDbInfo>> getDatabaseInfoList() {
        this.benchmarkDbInfoList = this.dbInfoRepository.findAll();
        return new ResponseDto((Object)this.benchmarkDbInfoList);
    }

    private void checkDbAndUpdateInfo(DatabaseInfoReq req, BenchmarkDbInfo dbInfo) {
        try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)dbInfo);){
            CreateDbMode createDbMode;
            if (conn == null) {
                throw new RuntimeException("Failed to create connection, please check connectivity");
            }
            if (StringUtils.isNotBlank((String)dbInfo.getSysbenchDbName())) {
                createDbMode = CreateDbMode.from((String)req.getSysbenchMode());
                if (createDbMode != null) {
                    JdbcUtil.createDb((Connection)conn, (String)req.getSysbenchDbName(), (CreateDbMode)createDbMode);
                } else {
                    createDbMode = JdbcUtil.getDbMode((Connection)conn, (String)req.getSysbenchDbName());
                }
                dbInfo.setSysbenchMode(createDbMode);
                this.sysbenchService.updateDbInfo(dbInfo);
            }
            if (StringUtils.isNotBlank((String)dbInfo.getTpccDbName())) {
                createDbMode = CreateDbMode.from((String)req.getTpccMode());
                if (createDbMode != null) {
                    JdbcUtil.createDb((Connection)conn, (String)req.getTpccDbName(), (CreateDbMode)createDbMode);
                } else {
                    createDbMode = JdbcUtil.getDbMode((Connection)conn, (String)req.getTpccDbName());
                }
                dbInfo.setTpccMode(createDbMode);
                this.tpccService.updateDbInfo(dbInfo);
            }
            if (StringUtils.isNotBlank((String)dbInfo.getTpchDbName())) {
                createDbMode = CreateDbMode.from((String)req.getTpchMode());
                if (createDbMode != null) {
                    JdbcUtil.createDb((Connection)conn, (String)req.getTpchDbName(), (CreateDbMode)createDbMode);
                } else {
                    createDbMode = JdbcUtil.getDbMode((Connection)conn, (String)req.getTpchDbName());
                }
                dbInfo.setTpchMode(createDbMode);
                this.tpchService.updateDbInfo(dbInfo);
            }
            if (StringUtils.isNotBlank((String)dbInfo.getTransferDbName())) {
                createDbMode = CreateDbMode.from((String)req.getTransferMode());
                if (createDbMode != null) {
                    JdbcUtil.createDb((Connection)conn, (String)req.getTransferDbName(), (CreateDbMode)createDbMode);
                } else {
                    createDbMode = JdbcUtil.getDbMode((Connection)conn, (String)req.getTransferDbName());
                }
                dbInfo.setTransferMode(createDbMode);
                this.transferService.updateDbInfo(dbInfo);
            }
        }
        catch (SQLException e) {
            log.warn(e.getMessage());
            throw new RuntimeException("Failed to create connection: " + e.getMessage());
        }
    }
}

