/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.service.MonitorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u538b\u6d4b\u673a\u76d1\u63a7\u7edf\u8ba1"})
@RestController
@RequestMapping(value={"/monitor"})
public class MonitorController {
    @Resource
    private MonitorService monitorService;

    @ApiOperation(value="\u83b7\u53d6CPU\u5229\u7528\u7387")
    @GetMapping(value={"/cpu"})
    public ResponseDto<Map<String, Double>> getCpuUsage() {
        HashMap<String, Double> result = new HashMap<String, Double>();
        result.put("cpu", this.monitorService.getCpuLoad());
        return new ResponseDto(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u53ef\u7528\u78c1\u76d8\u7a7a\u95f4")
    @GetMapping(value={"/freeDiskSpace"})
    public ResponseDto<String> getFreeDiskSpace() {
        double freeSpaceInGb = this.monitorService.getFreeDiskSpaceInGb();
        return new ResponseDto((Object)String.format("%.2f GB", freeSpaceInGb));
    }
}

