/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.controller.BaseBenchmarkController;
import com.polarx.benchmarkboot.controller.SysbenchController;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.SysbenchRunInfo;
import com.polarx.benchmarkboot.exception.TaskNotFoundException;
import com.polarx.benchmarkboot.model.BenchmarkStatus;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkType;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.SysbenchContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.SysbenchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.SysbenchProperty;
import com.polarx.benchmarkboot.model.dto.req.IdCompareReq;
import com.polarx.benchmarkboot.model.dto.req.IdReq;
import com.polarx.benchmarkboot.model.dto.req.MultiIdReq;
import com.polarx.benchmarkboot.model.dto.req.SysbenchPagerReq;
import com.polarx.benchmarkboot.model.dto.rsp.PagerResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.SingleDbInfoRsp;
import com.polarx.benchmarkboot.repo.SysbenchRunRepository;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.impl.SysbenchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Sysbench\u538b\u6d4b"})
@RestController
@RequestMapping(value={"/sysbench"})
public class SysbenchController
extends BaseBenchmarkController {
    private static final Logger log = LoggerFactory.getLogger(SysbenchController.class);
    @Resource
    private SysbenchService sysbenchService;
    @Resource
    private SysbenchRunRepository sysbenchRunRepository;

    public ResponseDto prepare(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        SysbenchPrepareProperty property = SysbenchPrepareProperty.from((JSONObject)req);
        SysbenchRunInfo runInfo = SysbenchRunInfo.from((SysbenchPrepareProperty)property);
        this.sysbenchRunRepository.save((Object)runInfo);
        SysbenchContext context = this.getContext();
        context.setRunInfo(runInfo);
        this.sysbenchService.prepare((BaseRunProperty)property, (RunningContext)context);
        log.info("Sysbench starts to load data");
        return new ResponseDto();
    }

    public ResponseDto run(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        this.beforeRunCheck();
        SysbenchProperty property = SysbenchProperty.from((JSONObject)req);
        SysbenchRunInfo runInfo = SysbenchRunInfo.from((SysbenchProperty)property, (JSONObject)req);
        this.sysbenchRunRepository.save((Object)runInfo);
        SysbenchContext context = this.getContext();
        context.setRunInfo(runInfo);
        this.sysbenchService.runBenchmark((BaseRunProperty)property, (RunningContext)context);
        log.info("Sysbench task-ID: {} is running", (Object)runInfo.getId());
        return new ResponseDto();
    }

    public ResponseDto stop() {
        this.beforeCheck();
        this.sysbenchService.stop();
        return new ResponseDto();
    }

    public ResponseDto rerun() {
        this.beforeCheck();
        if (this.sysbenchService.getStatus() != BenchmarkStatus.IDLE) {
            throw new IllegalStateException("Sysbench is still running");
        }
        SysbenchRunInfo lastRunInfo = this.sysbenchRunRepository.findTopByOrderByIdDesc();
        if (lastRunInfo == null) {
            throw new TaskNotFoundException("Last Sysbench task does not exist");
        }
        if (StringUtils.isBlank((String)lastRunInfo.getCommand())) {
            throw new TaskNotFoundException("Last Sysbench task is a loading task");
        }
        SysbenchRunInfo runInfo = SysbenchRunInfo.from((SysbenchRunInfo)lastRunInfo);
        this.sysbenchRunRepository.save((Object)runInfo);
        SysbenchContext context = this.getContext();
        context.setRunInfo(runInfo);
        SysbenchProperty property = SysbenchProperty.from((SysbenchRunInfo)runInfo);
        this.sysbenchService.runBenchmark((BaseRunProperty)property, (RunningContext)context);
        log.info("Sysbench task-ID: {} is running", (Object)runInfo.getId());
        return new ResponseDto();
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u538b\u6d4b\u7ed3\u679c")
    @GetMapping(value={"/result"})
    public PagerResponseDto<SysbenchRunInfo> getResult(@ModelAttribute @Valid SysbenchPagerReq req) {
        long count = this.sysbenchRunRepository.count();
        1 spec = new /* Unavailable Anonymous Inner Class!! */;
        PageRequest pageReq = PageRequest.of((int)(req.getCurrent() - 1), (int)req.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"}));
        List runInfoList = this.sysbenchRunRepository.findAll((Specification)spec, (Pageable)pageReq).getContent();
        PagerResponseDto result = new PagerResponseDto((Collection)runInfoList);
        result.setCurrent(req.getCurrent());
        result.setPageSize(req.getPageSize());
        result.setTotal(Long.valueOf(count));
        return result;
    }

    protected ILoggedBenchmarkRunInfo getRunInfoById(Integer id) {
        return this.sysbenchRunRepository.findById(id);
    }

    protected BaseBenchmarkService getBenchmarkService() {
        return this.sysbenchService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u6b21\u538b\u6d4bqps\u7edf\u8ba1")
    @GetMapping(value={"/result/qps"})
    public ResponseDto<List<QpsDataRecord>> getQpsResult(@ModelAttribute @Valid IdReq req) {
        List qpsDataRecordList = this.sysbenchService.getQpsResultList(req.getId());
        return new ResponseDto((Object)qpsDataRecordList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u65f6qps\u4fe1\u606f")
    @GetMapping(value={"/result/realtimeQps"})
    public ResponseDto<List<QpsDataRecord>> getRealtimeQpsResult(@ModelAttribute @Valid IdReq req) {
        List qpsDataRecordList = this.sysbenchService.getRealtimeQpsResultList(req.getId());
        return new ResponseDto((Object)qpsDataRecordList);
    }

    public ResponseDto<QpsCompareResult<SysbenchRunInfo>> compareResult(@ModelAttribute @Valid IdCompareReq req) {
        QpsCompareResult result = this.sysbenchService.compareResult(req.getId1(), req.getId2());
        return new ResponseDto((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u591a\u6b21\u538b\u6d4b\u7ed3\u679c\u7684\u5bf9\u6bd4\u8868\u683c")
    @PostMapping(value={"/result/compareMulti"})
    public ResponseDto<CompareResult<SysbenchRunInfo>> compareResult(@NotNull @RequestBody @Valid MultiIdReq req) {
        CompareResult result = this.sysbenchService.compareResult(req.getIdList());
        return new ResponseDto((Object)result);
    }

    public ResponseDto<SysbenchRunInfo> getLastRunArgs() {
        SysbenchRunInfo runInfo = this.sysbenchRunRepository.findTopByOrderByIdDesc();
        return new ResponseDto((Object)runInfo);
    }

    public ResponseDto<SingleDbInfoRsp> getDbInfo() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        if (benchmarkDbInfo == null) {
            return new ResponseDto(null);
        }
        SingleDbInfoRsp rsp = new SingleDbInfoRsp();
        rsp.setDbName(benchmarkDbInfo.getDbName(BenchmarkType.SYSBENCH));
        rsp.setDbMode(benchmarkDbInfo.getSysbenchMode().name());
        return new ResponseDto((Object)rsp);
    }

    protected void beforeCheck() {
        Lock readLock = BenchmarkContext.getInstance().readLock();
        try {
            readLock.lock();
            BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            if (benchmarkDbInfo == null || StringUtils.isBlank((String)benchmarkDbInfo.getSysbenchDbName())) {
                throw new RuntimeException("Sysbench database is not configured");
            }
        }
        finally {
            readLock.unlock();
        }
    }

    protected SysbenchContext getContext() {
        return (SysbenchContext)super.getContext();
    }
}

