/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.polarx.benchmarkboot.model.benchmark.SysbenchContext;
import com.polarx.benchmarkboot.service.worker.SysbenchResultWorker;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9e\u65f6qps"})
@ServerEndpoint(value="/result-sysbench")
@RestController
public class SysbenchResultStreamController {
    private SysbenchResultWorker thread;

    @OnOpen
    public void onOpen(Session session) {
        if (SysbenchContext.getInstance().getLogQueue().isEmpty()) {
            try {
                session.getBasicRemote().sendText("Sysbench is not running\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException("Sysbench is not running");
        }
        this.thread = new SysbenchResultWorker(SysbenchContext.getInstance(), session);
        this.thread.start();
    }

    @OnClose
    public void onClose() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @OnError
    public void onError(Throwable t) {
        t.printStackTrace();
    }
}

