/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.controller.BaseBenchmarkController;
import com.polarx.benchmarkboot.controller.TpccController;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.TpccRunInfo;
import com.polarx.benchmarkboot.exception.TaskNotFoundException;
import com.polarx.benchmarkboot.model.BenchmarkStatus;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkType;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TpccContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.TpccPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TpccProperty;
import com.polarx.benchmarkboot.model.dto.req.IdCompareReq;
import com.polarx.benchmarkboot.model.dto.req.IdReq;
import com.polarx.benchmarkboot.model.dto.req.MultiIdReq;
import com.polarx.benchmarkboot.model.dto.req.TpccPagerReq;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageRsp;
import com.polarx.benchmarkboot.model.dto.rsp.PagerResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.SingleDbInfoRsp;
import com.polarx.benchmarkboot.repo.TpccRunRepository;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.impl.TpccService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"TPC-C\u538b\u6d4b"})
@RestController
@RequestMapping(value={"/tpcc"})
public class TpccController
extends BaseBenchmarkController {
    private static final Logger log = LoggerFactory.getLogger(TpccController.class);
    @Resource
    private TpccService tpccService;
    @Resource
    private TpccRunRepository tpccRunRepository;

    public ResponseDto prepare(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        TpccPrepareProperty property = TpccPrepareProperty.from((JSONObject)req);
        TpccRunInfo runInfo = TpccRunInfo.from((TpccPrepareProperty)property);
        this.tpccRunRepository.save((Object)runInfo);
        TpccContext context = this.getContext();
        context.setRunInfo(runInfo);
        this.tpccService.prepare((BaseRunProperty)property, (RunningContext)this.getContext());
        log.info("TPC-C starts to load data");
        return new ResponseDto();
    }

    public ResponseDto run(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        this.beforeRunCheck();
        TpccProperty property = TpccProperty.from((JSONObject)req);
        TpccRunInfo runInfo = TpccRunInfo.from((TpccProperty)property, (JSONObject)req);
        this.tpccRunRepository.save((Object)runInfo);
        TpccContext context = this.getContext();
        context.setRunInfo(runInfo);
        this.tpccService.runBenchmark((BaseRunProperty)property, (RunningContext)context);
        log.info("TPC-C task-ID: {} is running", (Object)runInfo.getId());
        return new ResponseDto();
    }

    public ResponseDto stop() {
        this.beforeCheck();
        this.tpccService.stop();
        return new ResponseDto();
    }

    public ResponseDto rerun() {
        this.beforeCheck();
        if (this.tpccService.getStatus() != BenchmarkStatus.IDLE) {
            throw new IllegalStateException("TPC-C is still running");
        }
        TpccRunInfo lastRunInfo = this.tpccRunRepository.findTopByOrderByIdDesc();
        if (lastRunInfo == null) {
            throw new TaskNotFoundException("Last TPC-C task does not exist");
        }
        TpccRunInfo runInfo = TpccRunInfo.from((TpccRunInfo)lastRunInfo);
        this.tpccRunRepository.save((Object)runInfo);
        TpccContext context = this.getContext();
        context.setRunInfo(runInfo);
        TpccProperty property = TpccProperty.from((TpccRunInfo)runInfo);
        this.tpccService.runBenchmark((BaseRunProperty)property, (RunningContext)context);
        log.info("TPC-C task-ID: {} is running", (Object)runInfo.getId());
        return new ResponseDto();
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u538b\u6d4b\u7ed3\u679c")
    @GetMapping(value={"/result"})
    public PagerResponseDto<TpccRunInfo> getResult(@ModelAttribute @Valid TpccPagerReq req) {
        long count = this.tpccRunRepository.count();
        1 spec = new /* Unavailable Anonymous Inner Class!! */;
        PageRequest pageReq = PageRequest.of((int)(req.getCurrent() - 1), (int)req.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"}));
        List runInfoList = this.tpccRunRepository.findAll((Specification)spec, (Pageable)pageReq).getContent();
        PagerResponseDto result = new PagerResponseDto((Collection)runInfoList);
        result.setCurrent(req.getCurrent());
        result.setPageSize(req.getPageSize());
        result.setTotal(Long.valueOf(count));
        return result;
    }

    protected ILoggedBenchmarkRunInfo getRunInfoById(Integer id) {
        return this.tpccRunRepository.findById(id);
    }

    protected BaseBenchmarkService getBenchmarkService() {
        return this.tpccService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u6b21\u538b\u6d4btpmc\u7edf\u8ba1")
    @GetMapping(value={"/result/tpmc"})
    public ResponseDto<List<QpsDataRecord>> getQpsResult(@ModelAttribute IdReq req) {
        List qpsDataRecordList = this.tpccService.getTpmcResultList(req.getId());
        return new ResponseDto((Object)qpsDataRecordList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u65f6tpmC\u4fe1\u606f")
    @GetMapping(value={"/result/realtimeTpmc"})
    public ResponseDto<List<QpsDataRecord>> getRealtimeQpsResult(@ModelAttribute @Valid IdReq req) {
        List qpsDataRecordList = this.tpccService.getRealtimeQpsResultList(req.getId());
        return new ResponseDto((Object)qpsDataRecordList);
    }

    public ResponseDto<TpccRunInfo> getLastRunArgs() {
        TpccRunInfo runInfo = this.tpccRunRepository.findTopByOrderByIdDesc();
        runInfo.convertToMinutes();
        return new ResponseDto((Object)runInfo);
    }

    public ResponseDto<SingleDbInfoRsp> getDbInfo() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        if (benchmarkDbInfo == null) {
            return new ResponseDto(null);
        }
        SingleDbInfoRsp rsp = new SingleDbInfoRsp();
        rsp.setDbName(benchmarkDbInfo.getDbName(BenchmarkType.TPCC));
        rsp.setDbMode(benchmarkDbInfo.getTpccMode().name());
        return new ResponseDto((Object)rsp);
    }

    public ResponseDto<QpsCompareResult<TpccRunInfo>> compareResult(@ModelAttribute @Valid IdCompareReq req) {
        QpsCompareResult result = this.tpccService.compareResult(req.getId1(), req.getId2());
        return new ResponseDto((Object)result);
    }

    public ResponseDto<CompareResult<TpccRunInfo>> compareResult(@NotNull @RequestBody @Valid MultiIdReq req) {
        CompareResult result = this.tpccService.compareResult(req.getIdList());
        return new ResponseDto((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u6b21\u538b\u6d4b\u7684\u4e8b\u52a1\u54cd\u5e94\u65f6\u95f4")
    @GetMapping(value={"/result/trxRt"})
    public ResponseDto<MultiLineMessageRsp> getTrxRt(@ModelAttribute IdReq req) {
        String result = this.tpccService.getTrxResponseTime(req.getId());
        MultiLineMessageRsp rsp = new MultiLineMessageRsp(result);
        return new ResponseDto((Object)rsp);
    }

    protected void beforeCheck() {
        Lock readLock = BenchmarkContext.getInstance().readLock();
        try {
            readLock.lock();
            BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            if (benchmarkDbInfo == null || StringUtils.isBlank((String)benchmarkDbInfo.getTpccDbName())) {
                throw new RuntimeException("TPC-C database is not configured");
            }
        }
        finally {
            readLock.unlock();
        }
    }

    protected TpccContext getContext() {
        return (TpccContext)super.getContext();
    }
}

