/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.polarx.benchmarkboot.model.benchmark.TpccContext;
import com.polarx.benchmarkboot.service.worker.TpccResultWorker;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9e\u65f6tpmC"})
@ServerEndpoint(value="/result-tpcc")
@RestController
public class TpccResultStreamController {
    private TpccResultWorker thread;

    @OnOpen
    public void onOpen(Session session) {
        if (TpccContext.getInstance().getLogQueue().isEmpty()) {
            try {
                session.getBasicRemote().sendText("TPC-C is not running\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException("TPC-C is not running");
        }
        this.thread = new TpccResultWorker(TpccContext.getInstance(), session);
        this.thread.start();
    }

    @OnClose
    public void onClose() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @OnError
    public void onError(Throwable t) {
        t.printStackTrace();
    }
}

