/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.controller.BaseBenchmarkController;
import com.polarx.benchmarkboot.controller.TpchController;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.TpchRunInfo;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkType;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TpchContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.ComparePlanResult;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.PolarxPlanNode;
import com.polarx.benchmarkboot.model.bo.TpchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TpchProperty;
import com.polarx.benchmarkboot.model.dto.req.ComparePlanReq;
import com.polarx.benchmarkboot.model.dto.req.ExplainQueryReq;
import com.polarx.benchmarkboot.model.dto.req.IdCompareReq;
import com.polarx.benchmarkboot.model.dto.req.MultiIdReq;
import com.polarx.benchmarkboot.model.dto.req.TpchPagerReq;
import com.polarx.benchmarkboot.model.dto.rsp.ComparePlanRsp;
import com.polarx.benchmarkboot.model.dto.rsp.PagerResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.SingleDbInfoRsp;
import com.polarx.benchmarkboot.model.dto.rsp.TpchRunInfoRsp;
import com.polarx.benchmarkboot.repo.TpchRunRepository;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.impl.TpchService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"TPC-H\u538b\u6d4b"})
@RestController
@RequestMapping(value={"/tpch"})
public class TpchController
extends BaseBenchmarkController {
    private static final Logger log = LoggerFactory.getLogger(TpchController.class);
    @Resource
    private TpchService tpchService;
    @Resource
    private TpchRunRepository tpchRunRepository;

    public ResponseDto prepare(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        TpchPrepareProperty property = TpchPrepareProperty.from((JSONObject)req);
        TpchRunInfo runInfo = TpchRunInfo.from((String)BenchmarkContext.getInstance().getBenchmarkDbInfo().getDbName(BenchmarkType.TPCH), (TpchPrepareProperty)property);
        this.tpchRunRepository.save((Object)runInfo);
        TpchContext context = this.getContext();
        context.setRunInfo(runInfo);
        this.tpchService.prepare((BaseRunProperty)property, (RunningContext)this.getContext());
        log.info("TPC-H starts to load data");
        return new ResponseDto();
    }

    public ResponseDto run(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        this.beforeRunCheck();
        TpchProperty property = TpchProperty.from((JSONObject)req);
        TpchRunInfo runInfo = TpchRunInfo.from((TpchProperty)property, (JSONObject)req);
        runInfo.setDbName(BenchmarkContext.getInstance().getBenchmarkDbInfo().getTpchDbName());
        this.tpchRunRepository.save((Object)runInfo);
        TpchContext context = this.getContext();
        context.setRunInfo(runInfo);
        this.tpchService.runBenchmark((BaseRunProperty)property, (RunningContext)context);
        log.info("TPC-H task-ID: {} is running", (Object)runInfo.getId());
        return new ResponseDto();
    }

    public ResponseDto stop() {
        this.beforeCheck();
        this.tpchService.stop();
        return new ResponseDto();
    }

    public ResponseDto rerun() {
        throw new UnsupportedOperationException("Rerun TPC-H is not supported yet");
    }

    @ApiOperation(value="\u83b7\u53d6\u5206\u9875\u538b\u6d4b\u7ed3\u679c")
    @GetMapping(value={"/result"})
    public PagerResponseDto<TpchRunInfoRsp> getResult(@ModelAttribute @Valid TpchPagerReq req) {
        long count = this.tpchRunRepository.count();
        1 spec = new /* Unavailable Anonymous Inner Class!! */;
        PageRequest pageReq = PageRequest.of((int)(req.getCurrent() - 1), (int)req.getPageSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"createdAt"}));
        List runInfoList = this.tpchRunRepository.findAll((Specification)spec, (Pageable)pageReq).getContent().stream().map(TpchRunInfoRsp::from).collect(Collectors.toList());
        PagerResponseDto result = new PagerResponseDto(runInfoList);
        result.setCurrent(req.getCurrent());
        result.setPageSize(req.getPageSize());
        result.setTotal(Long.valueOf(count));
        return result;
    }

    public ResponseDto<TpchRunInfo> getLastRunArgs() {
        TpchRunInfo runInfo = this.tpchRunRepository.findTopByOrderByIdDesc();
        return new ResponseDto((Object)runInfo);
    }

    public ResponseDto<SingleDbInfoRsp> getDbInfo() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        if (benchmarkDbInfo == null) {
            return new ResponseDto(null);
        }
        SingleDbInfoRsp rsp = new SingleDbInfoRsp();
        rsp.setDbName(benchmarkDbInfo.getDbName(BenchmarkType.TPCH));
        rsp.setDbMode(benchmarkDbInfo.getTpchMode().name());
        return new ResponseDto((Object)rsp);
    }

    public ResponseDto<CompareResult<TpchRunInfoRsp>> compareResult(@ModelAttribute @Valid IdCompareReq req) {
        return this.compareResult(new MultiIdReq(List.of(req.getId1(), req.getId2())));
    }

    public ResponseDto<CompareResult<TpchRunInfoRsp>> compareResult(@NotNull @RequestBody @Valid MultiIdReq req) {
        CompareResult result = this.tpchService.compareResult(req.getIdList());
        List rspList = result.getTaskResultList().stream().map(TpchRunInfoRsp::from).collect(Collectors.toList());
        return new ResponseDto((Object)new CompareResult(rspList));
    }

    @ApiOperation(value="\u83b7\u53d6\u6267\u884c\u8ba1\u5212")
    @GetMapping(value={"/queryPlan"})
    public ResponseDto<List<PolarxPlanNode>> explainQuery(@NotNull @Valid @ModelAttribute ExplainQueryReq req) {
        this.beforeCheck();
        List plan = this.tpchService.getQueryPlan(req.getQueryId().intValue(), req.getHint());
        return new ResponseDto((Object)plan);
    }

    @ApiOperation(value="\u5bf9\u6bd4\u6267\u884c\u8ba1\u5212")
    @GetMapping(value={"/comparePlan"})
    public ResponseDto<ComparePlanRsp> comparePlan(@NotNull @Valid @ModelAttribute ComparePlanReq req) {
        this.beforeCheck();
        ComparePlanResult compareResult = this.tpchService.compareQueryPlan(req.getQueryId().intValue(), req.getHint1(), req.getHint2());
        ComparePlanRsp rsp = ComparePlanRsp.from((ComparePlanResult)compareResult);
        rsp.setHint1(req.getHint1());
        rsp.setHint2(req.getHint2());
        return new ResponseDto((Object)rsp);
    }

    @ApiOperation(value="\u83b7\u53d6\u5df2\u521b\u5efa\u7d22\u5f15")
    @GetMapping(value={"/createIndex"})
    public ResponseDto<String> getCreateIndex() {
        this.beforeCheck();
        throw new UnsupportedOperationException();
    }

    protected ILoggedBenchmarkRunInfo getRunInfoById(Integer id) {
        return this.tpchRunRepository.findById(id);
    }

    protected BaseBenchmarkService getBenchmarkService() {
        return this.tpchService;
    }

    protected void beforeCheck() {
        Lock readLock = BenchmarkContext.getInstance().readLock();
        try {
            BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            if (benchmarkDbInfo == null || StringUtils.isBlank((String)benchmarkDbInfo.getTpchDbName())) {
                throw new RuntimeException("TPC-H database is not configured");
            }
            if (benchmarkDbInfo.getTpchMode() == CreateDbMode.MYSQL) {
                throw new RuntimeException("TPC-H does not support normal MySQL. Please try PolarDB-X instead.");
            }
            readLock.lock();
        }
        finally {
            readLock.unlock();
        }
    }

    protected TpchContext getContext() {
        return (TpchContext)super.getContext();
    }
}

