/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.polarx.benchmarkboot.model.benchmark.TpchContext;
import com.polarx.benchmarkboot.service.worker.TpchResultWorker;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9e\u65f6\u8fdb\u5ea6"})
@ServerEndpoint(value="/result-tpch")
@RestController
public class TpchResultStreamController {
    private TpchResultWorker thread;

    @OnOpen
    public void onOpen(Session session) {
        if (TpchContext.getInstance().getLogQueue().isEmpty()) {
            try {
                session.getBasicRemote().sendText("TPC-H is not running or result has not been generated\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException("TPC-H is not running");
        }
        this.thread = new TpchResultWorker(TpchContext.getInstance(), session);
        this.thread.start();
    }

    @OnClose
    public void onClose() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @OnError
    public void onError(Throwable t) {
        t.printStackTrace();
    }
}

