/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.controller.BaseBenchmarkController;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.exception.HistoryNotSupportException;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkType;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TransferContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.TransferPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TransferProperty;
import com.polarx.benchmarkboot.model.dto.req.IdCompareReq;
import com.polarx.benchmarkboot.model.dto.req.IdReq;
import com.polarx.benchmarkboot.model.dto.req.MultiIdReq;
import com.polarx.benchmarkboot.model.dto.rsp.ResponseDto;
import com.polarx.benchmarkboot.model.dto.rsp.SingleDbInfoRsp;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.impl.TransferService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.annotation.Resource;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8f6c\u8d26\u6d4b\u8bd5"})
@RestController
@RequestMapping(value={"/transfer"})
public class TransferController
extends BaseBenchmarkController {
    private static final Logger log = LoggerFactory.getLogger(TransferController.class);
    @Resource
    private TransferService transferService;

    public ResponseDto prepare(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        TransferPrepareProperty property = TransferPrepareProperty.from((JSONObject)req);
        TransferContext context = this.getContext();
        this.transferService.prepare((BaseRunProperty)property, (RunningContext)context);
        log.info("Transfer starts to load data");
        return new ResponseDto();
    }

    public ResponseDto run(@NotNull @RequestBody JSONObject req) {
        this.beforeCheck();
        this.beforeRunCheck();
        TransferProperty property = TransferProperty.from((JSONObject)req);
        TransferContext context = this.getContext();
        this.transferService.runBenchmark((BaseRunProperty)property, (RunningContext)context);
        log.info("Transfer is running");
        return new ResponseDto();
    }

    public ResponseDto stop() {
        this.beforeCheck();
        this.transferService.stop();
        return new ResponseDto();
    }

    public ResponseDto rerun() {
        throw new HistoryNotSupportException();
    }

    protected ILoggedBenchmarkRunInfo getRunInfoById(Integer id) {
        throw new HistoryNotSupportException();
    }

    protected BaseBenchmarkService getBenchmarkService() {
        return this.transferService;
    }

    @ApiOperation(value="\u83b7\u53d6\u5355\u6b21\u538b\u6d4bqps\u7edf\u8ba1")
    @GetMapping(value={"/result/qps"})
    public ResponseDto<List<QpsDataRecord>> getQpsResult(@ModelAttribute @Valid IdReq req) {
        throw new HistoryNotSupportException();
    }

    @ApiOperation(value="\u83b7\u53d6\u5b9e\u65f6qps\u4fe1\u606f")
    @GetMapping(value={"/result/realtimeQps"})
    public ResponseDto<List<QpsDataRecord>> getRealtimeQpsResult(@ModelAttribute @Valid IdReq req) {
        throw new HistoryNotSupportException();
    }

    public ResponseDto compareResult(@ModelAttribute @Valid IdCompareReq req) {
        throw new HistoryNotSupportException();
    }

    @ApiOperation(value="\u83b7\u53d6\u591a\u6b21\u538b\u6d4b\u7ed3\u679c\u7684\u5bf9\u6bd4\u8868\u683c")
    @PostMapping(value={"/result/compareMulti"})
    public ResponseDto compareResult(@NotNull @RequestBody @Valid MultiIdReq req) {
        throw new HistoryNotSupportException();
    }

    public ResponseDto getLastRunArgs() {
        throw new HistoryNotSupportException();
    }

    public ResponseDto<SingleDbInfoRsp> getDbInfo() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        if (benchmarkDbInfo == null) {
            return new ResponseDto(null);
        }
        SingleDbInfoRsp rsp = new SingleDbInfoRsp();
        rsp.setDbName(benchmarkDbInfo.getDbName(BenchmarkType.TRANSFER));
        rsp.setDbMode(benchmarkDbInfo.getTransferMode().name());
        return new ResponseDto((Object)rsp);
    }

    protected void beforeCheck() {
        Lock readLock = BenchmarkContext.getInstance().readLock();
        try {
            readLock.lock();
            BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            if (benchmarkDbInfo == null || StringUtils.isBlank((String)benchmarkDbInfo.getTransferDbName())) {
                throw new RuntimeException("Transfer database is not configured");
            }
        }
        finally {
            readLock.unlock();
        }
    }

    protected TransferContext getContext() {
        return (TransferContext)super.getContext();
    }
}

