/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.controller;

import com.polarx.benchmarkboot.model.benchmark.TransferContext;
import com.polarx.benchmarkboot.service.worker.TransferResultWorker;
import io.swagger.annotations.Api;
import java.io.IOException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9e\u65f6tpmC"})
@ServerEndpoint(value="/result-transfer")
@RestController
public class TransferResultStreamController {
    private TransferResultWorker thread;

    @OnOpen
    public void onOpen(Session session) {
        if (TransferContext.getInstance().getLogQueue().isEmpty()) {
            try {
                session.getBasicRemote().sendText("Transfer is not running\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalStateException("Transfer is not running");
        }
        this.thread = new TransferResultWorker(TransferContext.getInstance(), session);
        this.thread.start();
    }

    @OnClose
    public void onClose() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
    }

    @OnError
    public void onError(Throwable t) {
        t.printStackTrace();
    }
}

