/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.model.LoadBalanceAddr;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkType;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.dto.req.DatabaseInfoReq;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.CreationTimestamp;

@Entity
@Table(indexes={@Index(columnList="host")})
public class BenchmarkDbInfo {
    private static final String MASKED_PASSWORD_STRING = "******";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer id;
    @Column(nullable=false)
    private String host;
    @Column(nullable=false)
    private Integer port;
    @Column(nullable=true)
    private String loadBalanceAddr = null;
    @Column(nullable=false)
    private String user;
    @Column(nullable=false)
    private String password;
    private String sysbenchDbName;
    @Enumerated(value=EnumType.ORDINAL)
    private CreateDbMode sysbenchMode = null;
    private String tpccDbName;
    @Enumerated(value=EnumType.ORDINAL)
    private CreateDbMode tpccMode = null;
    private String tpchDbName;
    @Enumerated(value=EnumType.ORDINAL)
    private CreateDbMode tpchMode = null;
    private String transferDbName;
    @Enumerated(value=EnumType.ORDINAL)
    private CreateDbMode transferMode = null;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(updatable=false)
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createdAt;

    public static BenchmarkDbInfo from(DatabaseInfoReq dbInfo) {
        BenchmarkDbInfo benchmarkDbInfo = new BenchmarkDbInfo();
        if (dbInfo.isLoadBalance()) {
            LoadBalanceAddr lbAddr = LoadBalanceAddr.parse((String)dbInfo.getHost());
            benchmarkDbInfo.loadBalanceAddr = lbAddr.getAddr();
            benchmarkDbInfo.host = (String)lbAddr.getFirstAddrPair().getFirst();
            benchmarkDbInfo.port = (Integer)lbAddr.getFirstAddrPair().getSecond();
        } else {
            benchmarkDbInfo.host = dbInfo.getHost();
            benchmarkDbInfo.port = dbInfo.getPort();
            benchmarkDbInfo.loadBalanceAddr = null;
        }
        benchmarkDbInfo.user = dbInfo.getUser();
        benchmarkDbInfo.password = dbInfo.getPassword();
        benchmarkDbInfo.sysbenchDbName = dbInfo.getSysbenchDbName();
        benchmarkDbInfo.tpccDbName = dbInfo.getTpccDbName();
        benchmarkDbInfo.tpchDbName = dbInfo.getTpchDbName();
        benchmarkDbInfo.transferDbName = dbInfo.getTransferDbName();
        return benchmarkDbInfo;
    }

    public boolean isLoadBalance() {
        return StringUtils.isNotBlank((String)this.loadBalanceAddr);
    }

    public String fetchPasswordPlainText() {
        return this.password;
    }

    public String getPassword() {
        return MASKED_PASSWORD_STRING;
    }

    public void updateFrom(BenchmarkDbInfo benchmarkDbInfo) {
        this.setHost(benchmarkDbInfo.getHost());
        this.setPort(benchmarkDbInfo.getPort());
        this.setUser(benchmarkDbInfo.getUser());
        this.setLoadBalanceAddr(benchmarkDbInfo.getLoadBalanceAddr());
        this.setPassword(benchmarkDbInfo.fetchPasswordPlainText());
        this.setSysbenchDbName(benchmarkDbInfo.getSysbenchDbName());
        this.setSysbenchMode(benchmarkDbInfo.getSysbenchMode());
        this.setTpccDbName(benchmarkDbInfo.getTpccDbName());
        this.setTpccMode(benchmarkDbInfo.getTpccMode());
        this.setTpchDbName(benchmarkDbInfo.getTpchDbName());
        this.setTpchMode(benchmarkDbInfo.getTpchMode());
    }

    public String getDbName(BenchmarkType type) {
        switch (1.$SwitchMap$com$polarx$benchmarkboot$model$benchmark$BenchmarkType[type.ordinal()]) {
            case 1: {
                return this.sysbenchDbName;
            }
            case 2: {
                return this.tpccDbName;
            }
            case 3: {
                return this.tpchDbName;
            }
            case 4: {
                return this.transferDbName;
            }
        }
        throw new UnsupportedOperationException("Unknown benchmark type: " + type.getName());
    }

    public Integer getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getLoadBalanceAddr() {
        return this.loadBalanceAddr;
    }

    public String getUser() {
        return this.user;
    }

    public String getSysbenchDbName() {
        return this.sysbenchDbName;
    }

    public CreateDbMode getSysbenchMode() {
        return this.sysbenchMode;
    }

    public String getTpccDbName() {
        return this.tpccDbName;
    }

    public CreateDbMode getTpccMode() {
        return this.tpccMode;
    }

    public String getTpchDbName() {
        return this.tpchDbName;
    }

    public CreateDbMode getTpchMode() {
        return this.tpchMode;
    }

    public String getTransferDbName() {
        return this.transferDbName;
    }

    public CreateDbMode getTransferMode() {
        return this.transferMode;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setLoadBalanceAddr(String loadBalanceAddr) {
        this.loadBalanceAddr = loadBalanceAddr;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSysbenchDbName(String sysbenchDbName) {
        this.sysbenchDbName = sysbenchDbName;
    }

    public void setSysbenchMode(CreateDbMode sysbenchMode) {
        this.sysbenchMode = sysbenchMode;
    }

    public void setTpccDbName(String tpccDbName) {
        this.tpccDbName = tpccDbName;
    }

    public void setTpccMode(CreateDbMode tpccMode) {
        this.tpccMode = tpccMode;
    }

    public void setTpchDbName(String tpchDbName) {
        this.tpchDbName = tpchDbName;
    }

    public void setTpchMode(CreateDbMode tpchMode) {
        this.tpchMode = tpchMode;
    }

    public void setTransferDbName(String transferDbName) {
        this.transferDbName = transferDbName;
    }

    public void setTransferMode(CreateDbMode transferMode) {
        this.transferMode = transferMode;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BenchmarkDbInfo)) {
            return false;
        }
        BenchmarkDbInfo other = (BenchmarkDbInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$loadBalanceAddr = this.getLoadBalanceAddr();
        String other$loadBalanceAddr = other.getLoadBalanceAddr();
        if (this$loadBalanceAddr == null ? other$loadBalanceAddr != null : !this$loadBalanceAddr.equals(other$loadBalanceAddr)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$sysbenchDbName = this.getSysbenchDbName();
        String other$sysbenchDbName = other.getSysbenchDbName();
        if (this$sysbenchDbName == null ? other$sysbenchDbName != null : !this$sysbenchDbName.equals(other$sysbenchDbName)) {
            return false;
        }
        CreateDbMode this$sysbenchMode = this.getSysbenchMode();
        CreateDbMode other$sysbenchMode = other.getSysbenchMode();
        if (this$sysbenchMode == null ? other$sysbenchMode != null : !this$sysbenchMode.equals(other$sysbenchMode)) {
            return false;
        }
        String this$tpccDbName = this.getTpccDbName();
        String other$tpccDbName = other.getTpccDbName();
        if (this$tpccDbName == null ? other$tpccDbName != null : !this$tpccDbName.equals(other$tpccDbName)) {
            return false;
        }
        CreateDbMode this$tpccMode = this.getTpccMode();
        CreateDbMode other$tpccMode = other.getTpccMode();
        if (this$tpccMode == null ? other$tpccMode != null : !this$tpccMode.equals(other$tpccMode)) {
            return false;
        }
        String this$tpchDbName = this.getTpchDbName();
        String other$tpchDbName = other.getTpchDbName();
        if (this$tpchDbName == null ? other$tpchDbName != null : !this$tpchDbName.equals(other$tpchDbName)) {
            return false;
        }
        CreateDbMode this$tpchMode = this.getTpchMode();
        CreateDbMode other$tpchMode = other.getTpchMode();
        if (this$tpchMode == null ? other$tpchMode != null : !this$tpchMode.equals(other$tpchMode)) {
            return false;
        }
        String this$transferDbName = this.getTransferDbName();
        String other$transferDbName = other.getTransferDbName();
        if (this$transferDbName == null ? other$transferDbName != null : !this$transferDbName.equals(other$transferDbName)) {
            return false;
        }
        CreateDbMode this$transferMode = this.getTransferMode();
        CreateDbMode other$transferMode = other.getTransferMode();
        if (this$transferMode == null ? other$transferMode != null : !this$transferMode.equals(other$transferMode)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        return !(this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BenchmarkDbInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $loadBalanceAddr = this.getLoadBalanceAddr();
        result = result * 59 + ($loadBalanceAddr == null ? 43 : $loadBalanceAddr.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $sysbenchDbName = this.getSysbenchDbName();
        result = result * 59 + ($sysbenchDbName == null ? 43 : $sysbenchDbName.hashCode());
        CreateDbMode $sysbenchMode = this.getSysbenchMode();
        result = result * 59 + ($sysbenchMode == null ? 43 : $sysbenchMode.hashCode());
        String $tpccDbName = this.getTpccDbName();
        result = result * 59 + ($tpccDbName == null ? 43 : $tpccDbName.hashCode());
        CreateDbMode $tpccMode = this.getTpccMode();
        result = result * 59 + ($tpccMode == null ? 43 : $tpccMode.hashCode());
        String $tpchDbName = this.getTpchDbName();
        result = result * 59 + ($tpchDbName == null ? 43 : $tpchDbName.hashCode());
        CreateDbMode $tpchMode = this.getTpchMode();
        result = result * 59 + ($tpchMode == null ? 43 : $tpchMode.hashCode());
        String $transferDbName = this.getTransferDbName();
        result = result * 59 + ($transferDbName == null ? 43 : $transferDbName.hashCode());
        CreateDbMode $transferMode = this.getTransferMode();
        result = result * 59 + ($transferMode == null ? 43 : $transferMode.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        return result;
    }

    public String toString() {
        return "BenchmarkDbInfo(id=" + this.getId() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", loadBalanceAddr=" + this.getLoadBalanceAddr() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", sysbenchDbName=" + this.getSysbenchDbName() + ", sysbenchMode=" + this.getSysbenchMode() + ", tpccDbName=" + this.getTpccDbName() + ", tpccMode=" + this.getTpccMode() + ", tpchDbName=" + this.getTpchDbName() + ", tpchMode=" + this.getTpchMode() + ", transferDbName=" + this.getTransferDbName() + ", transferMode=" + this.getTransferMode() + ", createdAt=" + this.getCreatedAt() + ")";
    }
}

