/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.entity;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.bo.SysbenchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.SysbenchProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.CreationTimestamp;

@Entity
public class SysbenchRunInfo
implements ILoggedBenchmarkRunInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer id;
    private String workload;
    private Integer threads;
    private Integer tables;
    private Integer tableSize;
    private Integer time;
    private String command;
    private String desc;
    private String dbParams;
    private String person;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(updatable=false)
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createdAt;
    @Enumerated(value=EnumType.ORDINAL)
    private RunningStatus status = RunningStatus.READY;
    private String qps;
    private String tps;
    private String latency;
    private String logFilePath;
    private String extra;

    protected SysbenchRunInfo() {
    }

    public static SysbenchRunInfo from(SysbenchRunInfo info) {
        SysbenchRunInfo runInfo = new SysbenchRunInfo();
        runInfo.tables = info.getTables();
        runInfo.tableSize = info.getTableSize();
        runInfo.time = info.getTime();
        runInfo.threads = info.getThreads();
        runInfo.workload = info.getWorkload();
        runInfo.dbParams = info.getDbParams();
        runInfo.desc = info.getDesc();
        runInfo.person = info.getPerson();
        return runInfo;
    }

    public static SysbenchRunInfo from(SysbenchProperty property, JSONObject propertyMap) {
        SysbenchRunInfo runInfo = new SysbenchRunInfo();
        runInfo.tables = property.getTables();
        runInfo.tableSize = property.getTableSize();
        runInfo.time = property.getTime();
        runInfo.threads = property.getThreads();
        runInfo.workload = property.getWorkload();
        runInfo.dbParams = propertyMap.getString("dbParams");
        runInfo.desc = propertyMap.getString("desc");
        runInfo.person = propertyMap.getString("person");
        return runInfo;
    }

    public static SysbenchRunInfo from(SysbenchPrepareProperty prepareProperty) {
        SysbenchRunInfo runInfo = new SysbenchRunInfo();
        runInfo.tables = prepareProperty.getTables();
        runInfo.tableSize = prepareProperty.getTableSize();
        runInfo.threads = prepareProperty.getThreads();
        runInfo.time = 0;
        runInfo.desc = "Sysbench \u5bfc\u5165\u4efb\u52a1";
        return runInfo;
    }

    public void setTimeSec(int seconds) {
        this.time = seconds;
    }

    public Integer getId() {
        return this.id;
    }

    public String getWorkload() {
        return this.workload;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public Integer getTables() {
        return this.tables;
    }

    public Integer getTableSize() {
        return this.tableSize;
    }

    public Integer getTime() {
        return this.time;
    }

    public String getCommand() {
        return this.command;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDbParams() {
        return this.dbParams;
    }

    public String getPerson() {
        return this.person;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public RunningStatus getStatus() {
        return this.status;
    }

    public String getQps() {
        return this.qps;
    }

    public String getTps() {
        return this.tps;
    }

    public String getLatency() {
        return this.latency;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setWorkload(String workload) {
        this.workload = workload;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public void setTables(Integer tables) {
        this.tables = tables;
    }

    public void setTableSize(Integer tableSize) {
        this.tableSize = tableSize;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setDbParams(String dbParams) {
        this.dbParams = dbParams;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setStatus(RunningStatus status) {
        this.status = status;
    }

    public void setQps(String qps) {
        this.qps = qps;
    }

    public void setTps(String tps) {
        this.tps = tps;
    }

    public void setLatency(String latency) {
        this.latency = latency;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysbenchRunInfo)) {
            return false;
        }
        SysbenchRunInfo other = (SysbenchRunInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$threads = this.getThreads();
        Integer other$threads = other.getThreads();
        if (this$threads == null ? other$threads != null : !((Object)this$threads).equals(other$threads)) {
            return false;
        }
        Integer this$tables = this.getTables();
        Integer other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables)) {
            return false;
        }
        Integer this$tableSize = this.getTableSize();
        Integer other$tableSize = other.getTableSize();
        if (this$tableSize == null ? other$tableSize != null : !((Object)this$tableSize).equals(other$tableSize)) {
            return false;
        }
        Integer this$time = this.getTime();
        Integer other$time = other.getTime();
        if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
            return false;
        }
        String this$workload = this.getWorkload();
        String other$workload = other.getWorkload();
        if (this$workload == null ? other$workload != null : !this$workload.equals(other$workload)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$dbParams = this.getDbParams();
        String other$dbParams = other.getDbParams();
        if (this$dbParams == null ? other$dbParams != null : !this$dbParams.equals(other$dbParams)) {
            return false;
        }
        String this$person = this.getPerson();
        String other$person = other.getPerson();
        if (this$person == null ? other$person != null : !this$person.equals(other$person)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        RunningStatus this$status = this.getStatus();
        RunningStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$qps = this.getQps();
        String other$qps = other.getQps();
        if (this$qps == null ? other$qps != null : !this$qps.equals(other$qps)) {
            return false;
        }
        String this$tps = this.getTps();
        String other$tps = other.getTps();
        if (this$tps == null ? other$tps != null : !this$tps.equals(other$tps)) {
            return false;
        }
        String this$latency = this.getLatency();
        String other$latency = other.getLatency();
        if (this$latency == null ? other$latency != null : !this$latency.equals(other$latency)) {
            return false;
        }
        String this$logFilePath = this.getLogFilePath();
        String other$logFilePath = other.getLogFilePath();
        if (this$logFilePath == null ? other$logFilePath != null : !this$logFilePath.equals(other$logFilePath)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysbenchRunInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $threads = this.getThreads();
        result = result * 59 + ($threads == null ? 43 : ((Object)$threads).hashCode());
        Integer $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        Integer $tableSize = this.getTableSize();
        result = result * 59 + ($tableSize == null ? 43 : ((Object)$tableSize).hashCode());
        Integer $time = this.getTime();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        String $workload = this.getWorkload();
        result = result * 59 + ($workload == null ? 43 : $workload.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $dbParams = this.getDbParams();
        result = result * 59 + ($dbParams == null ? 43 : $dbParams.hashCode());
        String $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : $person.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        RunningStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $qps = this.getQps();
        result = result * 59 + ($qps == null ? 43 : $qps.hashCode());
        String $tps = this.getTps();
        result = result * 59 + ($tps == null ? 43 : $tps.hashCode());
        String $latency = this.getLatency();
        result = result * 59 + ($latency == null ? 43 : $latency.hashCode());
        String $logFilePath = this.getLogFilePath();
        result = result * 59 + ($logFilePath == null ? 43 : $logFilePath.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        return result;
    }

    public String toString() {
        return "SysbenchRunInfo(id=" + this.getId() + ", workload=" + this.getWorkload() + ", threads=" + this.getThreads() + ", tables=" + this.getTables() + ", tableSize=" + this.getTableSize() + ", time=" + this.getTime() + ", command=" + this.getCommand() + ", desc=" + this.getDesc() + ", dbParams=" + this.getDbParams() + ", person=" + this.getPerson() + ", createdAt=" + this.getCreatedAt() + ", status=" + this.getStatus() + ", qps=" + this.getQps() + ", tps=" + this.getTps() + ", latency=" + this.getLatency() + ", logFilePath=" + this.getLogFilePath() + ", extra=" + this.getExtra() + ")";
    }
}

