/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.entity;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.bo.TpccPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TpccProperty;
import java.lang.constant.Constable;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.CreationTimestamp;

@Entity
public class TpccRunInfo
implements ILoggedBenchmarkRunInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer id;
    @Column(updatable=false)
    private int warehouses;
    @Column(updatable=false)
    private int threads;
    private int time;
    private String desc;
    private String dbParams;
    private String person;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(updatable=false)
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createdAt;
    @Enumerated(value=EnumType.ORDINAL)
    private RunningStatus status = RunningStatus.READY;
    private String tpmC;
    private String logFilePath;
    private String extra;

    protected TpccRunInfo() {
    }

    public static TpccRunInfo from(TpccProperty tpccProperty, JSONObject propertyMap) {
        TpccRunInfo runInfo = new TpccRunInfo();
        runInfo.warehouses = tpccProperty.getWarehouses();
        runInfo.threads = tpccProperty.getThreads();
        runInfo.time = tpccProperty.getTimeMins() * 60;
        runInfo.dbParams = propertyMap.getString("dbParams");
        runInfo.desc = propertyMap.getString("desc");
        runInfo.person = propertyMap.getString("person");
        HashMap<String, Constable> extraMap = new HashMap<String, Constable>();
        extraMap.put("newOrderRemotePercent", Integer.valueOf(tpccProperty.getNewOrderRemotePercent()));
        extraMap.put("paymentRemotePercent", Integer.valueOf(tpccProperty.getPaymentRemotePercent()));
        extraMap.put("saveTrxRt", Boolean.valueOf(tpccProperty.isSaveTrxRt()));
        extraMap.put("useStoredProcedure", Boolean.valueOf(tpccProperty.isUseStoredProcedure()));
        runInfo.extra = JSON.toJSONString(extraMap);
        return runInfo;
    }

    public static TpccRunInfo from(TpccPrepareProperty prepareProperty) {
        TpccRunInfo runInfo = new TpccRunInfo();
        runInfo.warehouses = prepareProperty.getWarehouses();
        runInfo.threads = prepareProperty.getThreads();
        runInfo.time = 0;
        runInfo.desc = "TPC-C \u5bfc\u5165\u4efb\u52a1";
        return runInfo;
    }

    public static TpccRunInfo from(TpccRunInfo lastRunInfo) {
        TpccRunInfo runInfo = new TpccRunInfo();
        runInfo.setWarehouses(lastRunInfo.getWarehouses());
        runInfo.setThreads(lastRunInfo.getThreads());
        runInfo.setTime(lastRunInfo.getTime());
        runInfo.setDesc(lastRunInfo.getDesc());
        runInfo.setDbParams(lastRunInfo.getDbParams());
        runInfo.setPerson(lastRunInfo.getPerson());
        return runInfo;
    }

    public void setTimeSec(int seconds) {
        this.time = seconds;
    }

    public void convertToMinutes() {
        this.time /= 60;
    }

    public int getTimeMinutes() {
        return this.time / 60;
    }

    public Integer getId() {
        return this.id;
    }

    public int getWarehouses() {
        return this.warehouses;
    }

    public int getThreads() {
        return this.threads;
    }

    public int getTime() {
        return this.time;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDbParams() {
        return this.dbParams;
    }

    public String getPerson() {
        return this.person;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public RunningStatus getStatus() {
        return this.status;
    }

    public String getTpmC() {
        return this.tpmC;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setWarehouses(int warehouses) {
        this.warehouses = warehouses;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setDbParams(String dbParams) {
        this.dbParams = dbParams;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setStatus(RunningStatus status) {
        this.status = status;
    }

    public void setTpmC(String tpmC) {
        this.tpmC = tpmC;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TpccRunInfo)) {
            return false;
        }
        TpccRunInfo other = (TpccRunInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getWarehouses() != other.getWarehouses()) {
            return false;
        }
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$dbParams = this.getDbParams();
        String other$dbParams = other.getDbParams();
        if (this$dbParams == null ? other$dbParams != null : !this$dbParams.equals(other$dbParams)) {
            return false;
        }
        String this$person = this.getPerson();
        String other$person = other.getPerson();
        if (this$person == null ? other$person != null : !this$person.equals(other$person)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        RunningStatus this$status = this.getStatus();
        RunningStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$tpmC = this.getTpmC();
        String other$tpmC = other.getTpmC();
        if (this$tpmC == null ? other$tpmC != null : !this$tpmC.equals(other$tpmC)) {
            return false;
        }
        String this$logFilePath = this.getLogFilePath();
        String other$logFilePath = other.getLogFilePath();
        if (this$logFilePath == null ? other$logFilePath != null : !this$logFilePath.equals(other$logFilePath)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TpccRunInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWarehouses();
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getTime();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $dbParams = this.getDbParams();
        result = result * 59 + ($dbParams == null ? 43 : $dbParams.hashCode());
        String $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : $person.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        RunningStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $tpmC = this.getTpmC();
        result = result * 59 + ($tpmC == null ? 43 : $tpmC.hashCode());
        String $logFilePath = this.getLogFilePath();
        result = result * 59 + ($logFilePath == null ? 43 : $logFilePath.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        return result;
    }

    public String toString() {
        return "TpccRunInfo(id=" + this.getId() + ", warehouses=" + this.getWarehouses() + ", threads=" + this.getThreads() + ", time=" + this.getTime() + ", desc=" + this.getDesc() + ", dbParams=" + this.getDbParams() + ", person=" + this.getPerson() + ", createdAt=" + this.getCreatedAt() + ", status=" + this.getStatus() + ", tpmC=" + this.getTpmC() + ", logFilePath=" + this.getLogFilePath() + ", extra=" + this.getExtra() + ")";
    }
}

