/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.entity;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.bo.TpchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TpchProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.CreationTimestamp;

@Entity
public class TpchRunInfo
implements ILoggedBenchmarkRunInfo {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Integer id;
    private String dbName;
    @Column(updatable=false)
    private boolean allQueries;
    @Column(updatable=false)
    @JSONField(serialize=false)
    private String queryHints;
    @JSONField(serialize=false)
    private String result;
    private String total;
    private String desc;
    private String dbParams;
    private String person;
    @CreationTimestamp
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(updatable=false)
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date createdAt;
    @Enumerated(value=EnumType.ORDINAL)
    private RunningStatus status = RunningStatus.READY;
    private String logFilePath;
    private String extra;

    protected TpchRunInfo() {
    }

    public static TpchRunInfo from(TpchProperty property, JSONObject propertyMap) {
        TpchRunInfo runInfo = new TpchRunInfo();
        runInfo.allQueries = property.isAllQueries();
        runInfo.queryHints = property.getQueryHintMap().toJsonStr();
        runInfo.dbParams = propertyMap.getString("dbParams");
        runInfo.desc = propertyMap.getString("desc");
        runInfo.person = propertyMap.getString("person");
        return runInfo;
    }

    public static TpchRunInfo from(String dbName, TpchPrepareProperty prepareProperty) {
        TpchRunInfo runInfo = new TpchRunInfo();
        runInfo.dbName = dbName;
        runInfo.total = null;
        runInfo.desc = "TPC-H \u5bfc\u5165\u4efb\u52a1: " + prepareProperty.getGb() + "GB";
        return runInfo;
    }

    public void setTimeSec(int seconds) {
        this.total = Integer.toString(seconds);
    }

    public Integer getId() {
        return this.id;
    }

    public String getDbName() {
        return this.dbName;
    }

    public boolean isAllQueries() {
        return this.allQueries;
    }

    public String getQueryHints() {
        return this.queryHints;
    }

    public String getResult() {
        return this.result;
    }

    public String getTotal() {
        return this.total;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getDbParams() {
        return this.dbParams;
    }

    public String getPerson() {
        return this.person;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public RunningStatus getStatus() {
        return this.status;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public String getExtra() {
        return this.extra;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setAllQueries(boolean allQueries) {
        this.allQueries = allQueries;
    }

    public void setQueryHints(String queryHints) {
        this.queryHints = queryHints;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setDbParams(String dbParams) {
        this.dbParams = dbParams;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public void setStatus(RunningStatus status) {
        this.status = status;
    }

    public void setLogFilePath(String logFilePath) {
        this.logFilePath = logFilePath;
    }

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TpchRunInfo)) {
            return false;
        }
        TpchRunInfo other = (TpchRunInfo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isAllQueries() != other.isAllQueries()) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$queryHints = this.getQueryHints();
        String other$queryHints = other.getQueryHints();
        if (this$queryHints == null ? other$queryHints != null : !this$queryHints.equals(other$queryHints)) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$total = this.getTotal();
        String other$total = other.getTotal();
        if (this$total == null ? other$total != null : !this$total.equals(other$total)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        String this$dbParams = this.getDbParams();
        String other$dbParams = other.getDbParams();
        if (this$dbParams == null ? other$dbParams != null : !this$dbParams.equals(other$dbParams)) {
            return false;
        }
        String this$person = this.getPerson();
        String other$person = other.getPerson();
        if (this$person == null ? other$person != null : !this$person.equals(other$person)) {
            return false;
        }
        Date this$createdAt = this.getCreatedAt();
        Date other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        RunningStatus this$status = this.getStatus();
        RunningStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$logFilePath = this.getLogFilePath();
        String other$logFilePath = other.getLogFilePath();
        if (this$logFilePath == null ? other$logFilePath != null : !this$logFilePath.equals(other$logFilePath)) {
            return false;
        }
        String this$extra = this.getExtra();
        String other$extra = other.getExtra();
        return !(this$extra == null ? other$extra != null : !this$extra.equals(other$extra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TpchRunInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAllQueries() ? 79 : 97);
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $queryHints = this.getQueryHints();
        result = result * 59 + ($queryHints == null ? 43 : $queryHints.hashCode());
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : $total.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        String $dbParams = this.getDbParams();
        result = result * 59 + ($dbParams == null ? 43 : $dbParams.hashCode());
        String $person = this.getPerson();
        result = result * 59 + ($person == null ? 43 : $person.hashCode());
        Date $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        RunningStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $logFilePath = this.getLogFilePath();
        result = result * 59 + ($logFilePath == null ? 43 : $logFilePath.hashCode());
        String $extra = this.getExtra();
        result = result * 59 + ($extra == null ? 43 : $extra.hashCode());
        return result;
    }

    public String toString() {
        return "TpchRunInfo(id=" + this.getId() + ", dbName=" + this.getDbName() + ", allQueries=" + this.isAllQueries() + ", queryHints=" + this.getQueryHints() + ", result=" + this.getResult() + ", total=" + this.getTotal() + ", desc=" + this.getDesc() + ", dbParams=" + this.getDbParams() + ", person=" + this.getPerson() + ", createdAt=" + this.getCreatedAt() + ", status=" + this.getStatus() + ", logFilePath=" + this.getLogFilePath() + ", extra=" + this.getExtra() + ")";
    }
}

