/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.exception;

import com.alibaba.fastjson.support.spring.FastJsonJsonView;
import com.polarx.benchmarkboot.exception.BaseException;
import com.polarx.benchmarkboot.exception.BaseExceptionEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.handler.AbstractHandlerExceptionResolver;

public class BaseJsonSerializeHandlerExceptionResolver
extends AbstractHandlerExceptionResolver {
    private static final Logger logger = LoggerFactory.getLogger(BaseJsonSerializeHandlerExceptionResolver.class);

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    protected ModelAndView doResolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        logger.error("\u5f02\u5e38\u7edf\u4e00\u5904\u7406", (Throwable)ex);
        ResponseBody rexist = ((HandlerMethod)handler).getMethod().getAnnotation(ResponseBody.class);
        RestController rcexist = ((HandlerMethod)handler).getBeanType().getAnnotation(RestController.class);
        if (rexist != null || rcexist != null) {
            String message = ex.getMessage();
            Integer code = 500;
            if (ex instanceof BindException) {
                FieldError fieldError = ((BindException)ex).getBindingResult().getFieldError();
                message = fieldError.getDefaultMessage();
                code = BaseExceptionEnum.INVALID_PARAMETER.getCode();
            }
            if (ex.getCause() instanceof ValidationException) {
                ValidationException e = (ValidationException)ex.getCause();
                message = e.getMessage();
                code = BaseExceptionEnum.INVALID_PARAMETER.getCode();
            }
            if (ex instanceof MethodArgumentNotValidException) {
                message = ((MethodArgumentNotValidException)ex).getBindingResult().getFieldError().getDefaultMessage();
                code = BaseExceptionEnum.INVALID_PARAMETER.getCode();
            }
            if (ex instanceof ConstraintViolationException) {
                Set violationSet = ((ConstraintViolationException)ex).getConstraintViolations();
                Iterator iterator = violationSet.iterator();
                if (iterator.hasNext()) {
                    ConstraintViolation validator = (ConstraintViolation)iterator.next();
                    message = validator.getMessage();
                }
                code = BaseExceptionEnum.INVALID_PARAMETER.getCode();
            }
            if (ex instanceof BaseException) {
                message = ex.getMessage();
                code = ((BaseException)ex).getCode();
            }
            FastJsonJsonView jsonView = new FastJsonJsonView();
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            map.put("errCode", code);
            map.put("message", message);
            return new ModelAndView((View)jsonView).addObject("status", map);
        }
        return null;
    }
}

