/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.data.util.Pair;

public class LoadBalanceAddr {
    private final List<Pair<String, Integer>> addrList = new ArrayList();
    private final String addr;

    public static LoadBalanceAddr parse(String addr) {
        return new LoadBalanceAddr(addr);
    }

    private LoadBalanceAddr(String addr) {
        try {
            String[] addrs = StringUtils.split((String)addr, (char)',');
            if (addrs == null || addr.length() == 0) {
                throw new IllegalArgumentException("Empty addrs split by ','");
            }
            for (String s : addrs) {
                this.addrList.add(this.parseSingleAddr(s));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse load balance address: " + addr, e);
        }
        this.addr = addr;
    }

    private Pair<String, Integer> parseSingleAddr(String addr) {
        if (addr == null) {
            throw new NullPointerException();
        }
        String[] strs = StringUtils.split((String)addr, (char)':');
        if (strs == null || strs.length != 2) {
            throw new IllegalArgumentException("Failed to parse: " + addr);
        }
        String host = strs[0];
        Integer port = Integer.parseInt(strs[1]);
        return Pair.of((Object)host, (Object)port);
    }

    public String getFormattedHost() {
        return this.addrList.stream().map(Pair::getFirst).collect(Collectors.joining(","));
    }

    public String getFormattedPort() {
        return this.addrList.stream().map(pair -> ((Integer)pair.getSecond()).toString()).collect(Collectors.joining(","));
    }

    public List<Pair<String, Integer>> getAddrList() {
        return this.addrList;
    }

    public String getAddr() {
        return this.addr;
    }

    public Pair<String, Integer> getFirstAddrPair() {
        return (Pair)this.addrList.get(0);
    }
}

