/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model;

import com.polarx.benchmarkboot.model.dto.req.PagerReq;
import java.util.HashMap;
import java.util.Map;

public class Pager<T> {
    public static final int DEFAULT_PAGE_NO = 1;
    public static final int DEFAULT_PER_PAGE = 10;
    private Integer current;
    private Long total = 0L;
    private Integer pageSize;
    private Map<String, Object> extras;

    public Pager() {
    }

    public Pager(PagerReq pagerReq) {
        this(pagerReq.getCurrent(), pagerReq.getPageSize());
    }

    public Pager(Integer current, Integer count) {
        this.current = current;
        this.pageSize = count;
        this.extras = new HashMap();
    }

    public Integer getOffset() {
        return (this.getCurrent() - 1) * this.getPageSize();
    }

    public Long getTotalPageNo() {
        return this.total % (long)this.getPageSize().intValue() == 0L ? this.total / (long)this.getPageSize().intValue() : this.total / (long)this.getPageSize().intValue() + 1L;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public Map<String, Object> getExtras() {
        return this.extras;
    }

    public void setExtras(Map<String, Object> extras) {
        this.extras = extras;
    }

    public Integer getCurrent() {
        return this.current == null || (long)this.current.intValue() <= 0L ? 1 : this.current;
    }

    public void setCurrent(Integer current) {
        this.current = current;
    }

    public Integer getPageSize() {
        return this.pageSize == null || (long)this.pageSize.intValue() <= 0L ? 10 : this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }
}

