/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PathConfigConstant {
    private static final Logger log = LoggerFactory.getLogger(PathConfigConstant.class);
    private static final String BATCH_TOOL_NAME = "batch-tool.jar";
    private String DEFAULT_SYSBENCH_HOME;
    private String DEFAULT_TPCC_HOME;
    private String DEFAULT_TPCH_HOME;
    private String DEFAULT_TRANSFER_HOME;
    public String DATA_DIR;
    public String TOOLS_DIR;
    public String BATCH_TOOL_FILEPATH;
    public String TPCH_DATA_DIR;
    public String SYSBENCH_HOME;
    public String TPCC_HOME;
    public String TPCH_HOME;
    public String TRANSFER_HOME;
    public String SYSBENCH_CONF;
    public String TPCC_CONF;
    public String TPCC_ORIGIN_CONF;
    public String TPCH_CONF;
    public String TRANSFER_CONF;

    @Value(value="${benchmark-path.sysbench}")
    public void setDefaultSysbenchHome(String defaultSysbenchHome) {
        this.DEFAULT_SYSBENCH_HOME = defaultSysbenchHome;
    }

    @Value(value="${benchmark-path.tpcc}")
    public void setDefaultTpccHome(String defaultTpccHome) {
        this.DEFAULT_TPCC_HOME = defaultTpccHome;
    }

    @Value(value="${benchmark-path.tpch}")
    public void setDefaultTpchHome(String defaultTpchHome) {
        this.DEFAULT_TPCH_HOME = defaultTpchHome;
    }

    @Value(value="${benchmark-path.transfer}")
    public void setDefaultTransferHome(String defaultTransferHome) {
        this.DEFAULT_TRANSFER_HOME = defaultTransferHome;
    }

    @Value(value="${benchmark-path.data}")
    public void setDataDir(String dataDir) {
        this.DATA_DIR = dataDir;
        this.TPCH_DATA_DIR = dataDir + "tpch/";
    }

    @Value(value="${benchmark-path.tools}")
    public void setToolsDir(String toolsDir) {
        this.TOOLS_DIR = toolsDir;
        this.BATCH_TOOL_FILEPATH = toolsDir + BATCH_TOOL_NAME;
    }

    @PostConstruct
    public void init() {
        this.SYSBENCH_HOME = System.getProperty("SYSBENCH_HOME", this.DEFAULT_SYSBENCH_HOME);
        this.SYSBENCH_CONF = this.SYSBENCH_HOME + "/sysb.conf";
        this.TPCC_HOME = System.getProperty("TPCC_HOME", this.DEFAULT_TPCC_HOME);
        this.TPCC_CONF = this.TPCC_HOME + "/props.polarx";
        this.TPCC_ORIGIN_CONF = this.TPCC_HOME + "/props.mysql";
        this.TPCH_HOME = System.getProperty("TPCH_HOME", this.DEFAULT_TPCH_HOME);
        this.TPCH_CONF = this.TPCH_HOME + "/conn-params.conf";
        this.TRANSFER_HOME = System.getProperty("TRANSFER_HOME", this.DEFAULT_TRANSFER_HOME);
        this.TRANSFER_CONF = this.TRANSFER_HOME + "/config_polarx.toml";
        this.validate();
    }

    private void validate() {
        log.info("Sysbench home: {}", (Object)this.SYSBENCH_HOME);
        log.info("TPC-C home: {}", (Object)this.TPCC_HOME);
        log.info("TPC-H home: {}", (Object)this.TPCH_HOME);
        log.info("Transfer home: {}", (Object)this.TRANSFER_HOME);
        log.info("Tools home: {}", (Object)this.TOOLS_DIR);
    }
}

