/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.benchmark;

import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.model.benchmark.QpsLineProcessor;
import com.polarx.benchmarkboot.model.benchmark.StreamingCommandLineOutput;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import java.io.File;
import java.util.Queue;
import org.apache.commons.collections4.QueueUtils;
import org.apache.commons.collections4.queue.CircularFifoQueue;

public abstract class RunningContext
implements StreamingCommandLineOutput {
    private File logFile = null;
    protected Queue<String> logQueue = QueueUtils.synchronizedQueue((Queue)new CircularFifoQueue(1000));
    protected QpsLineProcessor realtimeQpsProcessor;
    protected Queue<QpsDataRecord> realtimeQpsQueue = QueueUtils.synchronizedQueue((Queue)new CircularFifoQueue(3600));

    public abstract int getTaskId();

    public abstract ILoggedBenchmarkRunInfo getRunInfo();

    public File getLogFile() {
        if (this.logFile == null) {
            throw new IllegalStateException("Log file has not been set");
        }
        return this.logFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    public void clearCircularBuffer() {
        this.clearLogBuffer();
        this.clearRealtimeQpsBuffer();
    }

    public void clearLogBuffer() {
        this.logQueue.clear();
    }

    public void clearRealtimeQpsBuffer() {
        this.realtimeQpsQueue.clear();
    }

    public abstract QpsLineProcessor newRealtimeQpsProcessor();

    public Queue<String> getLogQueue() {
        return this.logQueue;
    }

    public QpsLineProcessor getRealtimeQpsProcessor() {
        return this.realtimeQpsProcessor;
    }

    public Queue<QpsDataRecord> getRealtimeQpsQueue() {
        return this.realtimeQpsQueue;
    }
}

