/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.benchmark;

import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.benchmark.QueryWithHint;
import com.polarx.benchmarkboot.util.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpchQuery {
    private static final Logger log = LoggerFactory.getLogger(TpchQuery.class);
    private final String queryDir;
    public static final int MIN_QUERY_ID = 1;
    public static final int MAX_QUERY_ID = 22;
    private final String[] queries = new String[22];

    @Autowired
    public TpchQuery(PathConfigConstant pathConfigConstant) {
        this.queryDir = pathConfigConstant.TPCH_HOME + "/tpch-queries/";
    }

    @PostConstruct
    public void loadQuery() {
        for (int queryId = 1; queryId <= 22; ++queryId) {
            String fileName = String.format("%s/%02d.sql", this.queryDir, queryId);
            try {
                this.queries[queryId - 1] = new String(Files.readAllBytes(Paths.get(fileName, new String[0])));
                continue;
            }
            catch (IOException e) {
                log.error("Failed to load query-{}", (Object)queryId);
                throw new RuntimeException(e);
            }
        }
    }

    public String getSqlWithHint(int queryId, String hint) {
        Preconditions.checkArgument((queryId >= 1 && queryId <= 22 ? 1 : 0) != 0, (Object)queryId);
        return new QueryWithHint(this.queries[--queryId], hint).getSqlWithHint();
    }

    public String getExplainSqlWithHint(int queryId, String hint) {
        Preconditions.checkArgument((queryId >= 1 && queryId <= 22 ? 1 : 0) != 0, (Object)queryId);
        return new QueryWithHint("EXPLAIN " + this.queries[--queryId], hint).getSqlWithHint();
    }
}

