/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.benchmark;

import java.util.List;

public class TpchTableInfo {
    private final String name;
    private final int size;
    private final boolean scaleByFactor;
    private final boolean approximateSize;
    public static final TpchTableInfo REGION = new TpchTableInfo("region", 5, false, false);
    public static final TpchTableInfo NATION = new TpchTableInfo("nation", 25, false, false);
    public static final TpchTableInfo SUPPLIER = new TpchTableInfo("supplier", 10000, true, false);
    public static final TpchTableInfo CUSTOMER = new TpchTableInfo("customer", 150000, true, false);
    public static final TpchTableInfo PART = new TpchTableInfo("part", 200000, true, false);
    public static final TpchTableInfo PARTSUPP = new TpchTableInfo("partsupp", 800000, true, false);
    public static final TpchTableInfo ORDERS = new TpchTableInfo("orders", 1500000, true, false);
    public static final TpchTableInfo LINEITEM = new TpchTableInfo("lineitem", 6000000, true, true);
    public static final List<TpchTableInfo> TABLE_INFOS = new /* Unavailable Anonymous Inner Class!! */;

    public TpchTableInfo(String name, int size, boolean scaleByFactor, boolean approximateSize) {
        this.name = name;
        this.size = size;
        this.scaleByFactor = scaleByFactor;
        this.approximateSize = approximateSize;
    }

    public int getSize(int scaleFactor) {
        if (!this.scaleByFactor) {
            return this.size;
        }
        if (scaleFactor <= 0) {
            throw new IllegalArgumentException("Illegal scaleFactor: " + scaleFactor);
        }
        return this.size * scaleFactor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isApproximateSize() {
        return this.approximateSize;
    }
}

