/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.polarx.benchmarkboot.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PolarxPlanNode {
    private static final Logger log = LoggerFactory.getLogger(PolarxPlanNode.class);
    private static final char INDENT_CHAR = ' ';
    private static final int INDENT_COUNT = 2;
    private static final String INDENT_STR = "    ";
    private static final String LOGICAL_VIEW = "LogicalView";
    private static final String LV_TABLES_PREFIX = "tables=\"";
    private static final String LV_SQL_PREFIX = "sql=\"";
    private String node;
    private String desc;
    private int level;

    public PolarxPlanNode(String node) {
        this(node, "");
    }

    public PolarxPlanNode(@NotNull String node, @NotNull String desc) {
        this.node = node;
        this.desc = desc;
    }

    public static List<PolarxPlanNode> parse(@NotNull String planStr) {
        String[] lines = StringUtils.split((String)planStr, (char)'\n');
        ArrayList<PolarxPlanNode> resList = new ArrayList<PolarxPlanNode>(lines.length);
        for (String line : lines) {
            resList.add(PolarxPlanNode.parseLine((String)line));
        }
        return resList;
    }

    public static PolarxPlanNode parseLine(@NotNull String line) {
        PolarxPlanNode planNode;
        int idx;
        int len = line.length();
        Preconditions.checkArgument((len > 0 ? 1 : 0) != 0, (Object)"Empty plan line");
        for (idx = 0; idx < len && line.charAt(idx) == ' '; ++idx) {
        }
        int level = idx / 2;
        StringBuilder stringBuilder = new StringBuilder(128);
        while (idx < len && line.charAt(idx) != '(') {
            stringBuilder.append(line.charAt(idx));
            ++idx;
        }
        String node = stringBuilder.toString();
        stringBuilder.setLength(0);
        try {
            switch (node) {
                case "LogicalView": {
                    planNode = PolarxPlanNode.parseLogicalView((String)line, (int)idx, (int)level);
                    break;
                }
                default: {
                    planNode = PolarxPlanNode.parseDefault((String)node, (String)line, (int)idx, (int)level);
                    break;
                }
            }
        }
        catch (Exception e) {
            log.error("Failed at parsing line: {}", (Object)line);
            throw new RuntimeException(e);
        }
        planNode.setLevel(level);
        return planNode;
    }

    private static PolarxPlanNode parseDefault(String node, String line, int startIdx, int level) {
        int lastIdx = line.lastIndexOf(41);
        String desc = line.substring(startIdx + 1, lastIdx);
        return new PolarxPlanNode(PolarxPlanNode.getIndentStr((int)level) + node, desc);
    }

    private static PolarxPlanNode parseLogicalView(String line, int startIdx, int level) {
        String tables = null;
        String desc = null;
        int tablesStartIdx = line.indexOf("tables=\"", startIdx);
        if (tablesStartIdx == -1) {
            tables = "";
        } else {
            int lastIdx = line.indexOf("\"", tablesStartIdx += "tables=\"".length());
            tables = line.substring(tablesStartIdx, lastIdx);
        }
        int descStartIdx = line.indexOf("sql=\"", startIdx);
        if (descStartIdx == -1) {
            desc = "";
        } else {
            int lastIdx = line.lastIndexOf("\"");
            desc = line.substring(descStartIdx += "sql=\"".length(), lastIdx);
        }
        return new PolarxPlanNode(String.format("%s%s(%s)", PolarxPlanNode.getIndentStr((int)level), "LogicalView", tables), desc);
    }

    private static String getIndentStr(int level) {
        return StringUtils.repeat((String)"    ", (int)level);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolarxPlanNode that = (PolarxPlanNode)o;
        return this.node.equals(that.node) && Objects.equals(this.desc, that.desc);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.desc);
    }

    public String getNode() {
        return this.node;
    }

    public String getDesc() {
        return this.desc;
    }

    public int getLevel() {
        return this.level;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String toString() {
        return "PolarxPlanNode(node=" + this.getNode() + ", desc=" + this.getDesc() + ", level=" + this.getLevel() + ")";
    }

    public PolarxPlanNode() {
    }
}

