/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.polarx.benchmarkboot.model.bo.ColoredPolarxPlanNode;
import com.polarx.benchmarkboot.model.bo.PolarxPlanNode;
import com.polarx.benchmarkboot.model.bo.PolarxPlanTree;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Stack;

public class PolarxPlanTree {
    private PlanTreeNode root;

    public PolarxPlanTree(PlanTreeNode root) {
        this.root = root;
    }

    public static PolarxPlanTree buildTree(List<PolarxPlanNode> nodeList) {
        if (nodeList == null || nodeList.isEmpty()) {
            return null;
        }
        PlanTreeNode root = new PlanTreeNode(nodeList.get(0));
        PolarxPlanTree tree = new PolarxPlanTree(root);
        ArrayList<List<Object>> planNodeList = new ArrayList<List<Object>>();
        planNodeList.add(List.of(root));
        for (int i = 1; i < nodeList.size(); ++i) {
            PlanTreeNode curNode = new PlanTreeNode(nodeList.get(i));
            int curLevel = curNode.data.getLevel();
            if (planNodeList.size() <= curLevel) {
                planNodeList.add(new ArrayList());
            }
            ((List)planNodeList.get(curLevel)).add(curNode);
            List parentList = (List)planNodeList.get(curLevel - 1);
            PlanTreeNode parent = (PlanTreeNode)parentList.get(parentList.size() - 1);
            if (parent.left == null) {
                parent.left = curNode;
                continue;
            }
            if (parent.right == null) {
                parent.right = curNode;
                continue;
            }
            throw new IllegalStateException("Parent node already has two children");
        }
        return tree;
    }

    public List<ColoredPolarxPlanNode> markDiff(PolarxPlanTree otherTree) {
        if (otherTree == null) {
            throw new NullPointerException();
        }
        ArrayList resList = new ArrayList();
        Stack nodeStack = new Stack();
        PlanTreeNode oriRoot = this.root;
        PlanTreeNode otherRoot = otherTree.root;
        if (!oriRoot.equals((Object)otherRoot)) {
            // empty if block
        }
        return null;
    }

    public List<ColoredPolarxPlanNode> toList() {
        ArrayList<ColoredPolarxPlanNode> resList = new ArrayList<ColoredPolarxPlanNode>();
        Stack<PlanTreeNode> nodeStack = new Stack<PlanTreeNode>();
        nodeStack.push(this.root);
        while (!nodeStack.isEmpty()) {
            PlanTreeNode curNode = (PlanTreeNode)nodeStack.pop();
            if (curNode.right != null) {
                nodeStack.push(curNode.right);
            }
            if (curNode.left != null) {
                nodeStack.push(curNode.left);
            }
            resList.add(new ColoredPolarxPlanNode(curNode.data, curNode.color));
        }
        return resList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolarxPlanTree tree = (PolarxPlanTree)o;
        return Objects.equals(this.root, tree.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }
}

