/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.util.JdbcUtil;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareDataUtil {
    private static final Logger log = LoggerFactory.getLogger(PrepareDataUtil.class);
    static final int MIN_PARTITIONS = 24;
    static final int MAX_PARTITIONS = 4096;
    static final int PARTITIONS_PER_DN = 4;
    public static final int UNSET_PARTITIONS = -1;

    private PrepareDataUtil() {
    }

    public static int calcPartitions(int partitions) {
        int dnCount;
        if (partitions > 0) {
            return partitions;
        }
        if (partitions == -1) {
            try {
                dnCount = JdbcUtil.getDnCount((BenchmarkDbInfo)BenchmarkContext.getInstance().getBenchmarkDbInfo());
            }
            catch (SQLException e) {
                log.error(e.getMessage());
                dnCount = 24;
            }
        } else {
            throw new IllegalArgumentException("illegal partitions: " + partitions);
        }
        partitions = dnCount * 4;
        partitions = Math.min(partitions, 4096);
        partitions = Math.max(partitions, 24);
        log.info("Using partition count: {}, MAX={}, MIN={}", new Object[]{partitions, 4096, 24});
        return partitions;
    }
}

