/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.PrepareDataUtil;
import com.polarx.benchmarkboot.model.bo.SysbenchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.SysbenchProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SysbenchPrepareProperty
extends SysbenchProperty {
    private static final Logger log = LoggerFactory.getLogger(SysbenchPrepareProperty.class);
    private static final int MAX_THREADS_PER_TABLE = 16;
    private static final String CREATE_TABLE_OPTION_KEY = "createTableOptions";
    private static final String BALANCE_SINGLE_KEY = "balanceSingle";
    private static final String BALANCE_SINGLE_OPTION = "single locality=\"balance_single_table=on\"";
    private static final String DRDS_MODE_CREATE_TABLE_OPT = "dbpartition by hash(`id`)";
    private static final String AUTO_MODE_CREATE_TABLE_OPT_PRE = "PARTITION BY KEY(`id`)";
    private static final String MYSQL_MODE_CREATE_TABLE_OPT = "";
    private String createTableOptions;
    private int partitions;

    protected SysbenchPrepareProperty(JSONObject propertyMap) {
        super(propertyMap);
    }

    public static SysbenchPrepareProperty from(JSONObject propertyMap) {
        CreateDbMode sysbenchMode = BenchmarkContext.getInstance().getBenchmarkDbInfo().getSysbenchMode();
        SysbenchPrepareProperty property = new SysbenchPrepareProperty(propertyMap);
        boolean balanceSingle = (Boolean)propertyMap.getOrDefault((Object)"balanceSingle", (Object)true);
        if (balanceSingle) {
            if (sysbenchMode != CreateDbMode.AUTO) {
                throw new UnsupportedOperationException("Only AUTO mode supports balance_single mode");
            }
            property.partitions = 0;
            property.createTableOptions = "single locality=\"balance_single_table=on\"";
            return property;
        }
        property.partitions = (Integer)propertyMap.getOrDefault((Object)"partitions", (Object)-1);
        switch (1.$SwitchMap$com$polarx$benchmarkboot$model$bo$CreateDbMode[sysbenchMode.ordinal()]) {
            case 1: {
                property.createTableOptions = (String)propertyMap.getOrDefault((Object)"createTableOptions", (Object)"dbpartition by hash(`id`)");
                break;
            }
            case 2: {
                if (propertyMap.containsKey((Object)"createTableOptions")) {
                    property.createTableOptions = propertyMap.getString("createTableOptions");
                    break;
                }
                property.createTableOptions = SysbenchPrepareProperty.calcAutoCreateTableOpt((int)property.partitions);
                break;
            }
            case 3: {
                property.createTableOptions = (String)propertyMap.getOrDefault((Object)"createTableOptions", (Object)"");
            }
        }
        return property;
    }

    private static String calcAutoCreateTableOpt(int partitions) {
        partitions = PrepareDataUtil.calcPartitions((int)partitions);
        return String.format("%s PARTITIONS %d", "PARTITION BY KEY(`id`)", partitions);
    }

    public String getBuiltCommand() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("sysbench ");
        this.appendDbConnInfo(stringBuilder);
        this.appendKeyValue(stringBuilder, "create-table-options", (Object)this.getCreateTableOptions());
        this.appendKeyValue(stringBuilder, "tables", (Object)this.getTables());
        this.appendKeyValue(stringBuilder, "threads", (Object)this.getThreads());
        this.appendKeyValue(stringBuilder, "table-size", (Object)this.getTableSize());
        stringBuilder.append(" oltp_point_select prepare");
        return stringBuilder.toString();
    }

    public void prepareValidate() {
        if (this.getTables() <= 0 || this.getThreads() <= 0 || this.getTableSize() <= 0) {
            throw new IllegalArgumentException("Illegal tables or threads");
        }
        if (this.getThreads() > this.getTables() * 16) {
            throw new IllegalArgumentException("Parallelism is too high for one table");
        }
    }

    public String getCreateTableOptions() {
        return this.createTableOptions;
    }

    public int getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return "SysbenchPrepareProperty(createTableOptions=" + this.getCreateTableOptions() + ", partitions=" + this.getPartitions() + ")";
    }
}

