/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.SysbenchRunInfo;
import com.polarx.benchmarkboot.model.LoadBalanceAddr;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.util.JsonUtil;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;

public class SysbenchProperty
extends BaseRunProperty {
    private static final int DEFAULT_RANGE_SIZE = 5;
    private static final boolean DEFAULT_PREPARE_MODE = false;
    private static final boolean DEFAULT_SKIP_TRX = true;
    private static final String DEFAULT_IGNORE_ERRORS = "all";
    private static final String DEFAULT_WORKLOAD = "oltp_point_select";
    private static final int DEFAULT_RUN_TIME_SECOND = 60;
    private static final int DEFAULT_REPORT_INTERVAL_SECOND = 1;
    @NotNull
    @Min(value=1L, message="\u8868\u6570\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u8868\u6570\u4e0d\u80fd\u5c0f\u4e8e1") int tables;
    @NotNull
    @Min(value=1L, message="\u8868\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u8868\u5927\u5c0f\u4e0d\u80fd\u5c0f\u4e8e1") int tableSize;
    @NotNull
    @Min(value=1L, message="\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1") int threads;
    private String db;
    private int rangeSize;
    private boolean dbPsMode;
    private boolean skipTrx;
    private boolean printHistogram;
    private int reportInterval;
    private String ignoreErrors;
    @NotNull(message="\u8d1f\u8f7d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    private final @NotNull(message="\u8d1f\u8f7d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String workload;
    @Min(value=1L, message="\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e1s")
    private @Min(value=1L, message="\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e1s") int time;
    private String command;

    protected SysbenchProperty(int tables, int tableSize, int threads, String workload) {
        this.tables = tables;
        this.tableSize = tableSize;
        this.threads = threads;
        this.workload = workload;
    }

    protected SysbenchProperty(JSONObject propertyMap) {
        this(propertyMap.getIntValue("tables"), propertyMap.getIntValue("tableSize"), propertyMap.getIntValue("threads"), propertyMap.getString("workload"));
        String otherParams = propertyMap.getString("otherParams");
        JSONObject otherParamsObj = null;
        try {
            otherParamsObj = JSON.parseObject((String)otherParams);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse other params in JSON, " + e.getMessage());
        }
        JsonUtil.mergeJson((JSONObject)propertyMap, (JSONObject)otherParamsObj);
        this.db = propertyMap.getString("mysql-db");
        this.rangeSize = (Integer)propertyMap.getOrDefault((Object)"range-size", (Object)5);
        this.dbPsMode = (Boolean)propertyMap.getOrDefault((Object)"db-ps-mode", (Object)false);
        this.skipTrx = (Boolean)propertyMap.getOrDefault((Object)"skip-trx", (Object)true);
        this.ignoreErrors = (String)propertyMap.getOrDefault((Object)"mysql-ignore-errors", (Object)DEFAULT_IGNORE_ERRORS);
        this.time = (Integer)propertyMap.getOrDefault((Object)"time", (Object)60);
        this.reportInterval = (Integer)propertyMap.getOrDefault((Object)"report-interval", (Object)1);
        this.printHistogram = (Boolean)propertyMap.getOrDefault((Object)"histogram", (Object)false);
    }

    public static SysbenchProperty from(JSONObject propertyMap) {
        return new SysbenchProperty(propertyMap);
    }

    public static SysbenchProperty from(SysbenchRunInfo runInfo) {
        SysbenchProperty sysbenchProperty = new SysbenchProperty(runInfo.getTables().intValue(), runInfo.getTableSize().intValue(), runInfo.getThreads().intValue(), runInfo.getWorkload());
        sysbenchProperty.setTime(runInfo.getTime().intValue());
        sysbenchProperty.setRangeSize(5);
        sysbenchProperty.setDbPsMode(false);
        sysbenchProperty.setSkipTrx(true);
        sysbenchProperty.setIgnoreErrors(DEFAULT_IGNORE_ERRORS);
        sysbenchProperty.setReportInterval(1);
        return sysbenchProperty;
    }

    public String getBuiltCommand() {
        if (this.command != null) {
            return this.command;
        }
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("sysbench ");
        this.appendDbConnInfo(stringBuilder);
        if (StringUtils.isNotEmpty((String)this.getDb())) {
            this.appendKeyValue(stringBuilder, "mysql-db", (Object)this.getDb());
        }
        this.appendKeyValue(stringBuilder, "tables", (Object)this.getTables());
        this.appendKeyValue(stringBuilder, "threads", (Object)this.getThreads());
        this.appendKeyValue(stringBuilder, "table-size", (Object)this.getTableSize());
        this.appendKeyValue(stringBuilder, "range-size", (Object)this.getRangeSize());
        this.appendKeyValue(stringBuilder, "db-ps-mode", (Object)(this.isDbPsMode() ? "auto" : "disable"));
        this.appendKeyValue(stringBuilder, "skip-trx", (Object)(this.isSkipTrx() ? "on" : "off"));
        this.appendKeyValue(stringBuilder, "mysql-ignore-errors", (Object)this.getIgnoreErrors());
        this.appendKeyValue(stringBuilder, "time", (Object)this.getTime());
        this.appendKeyValue(stringBuilder, "report-interval", (Object)this.getReportInterval());
        this.appendKeyValue(stringBuilder, "histogram", (Object)(this.isPrintHistogram() ? "on" : "off"));
        stringBuilder.append(this.getWorkload()).append(" run");
        return stringBuilder.toString();
    }

    protected void appendDbConnInfo(StringBuilder stringBuilder) {
        BenchmarkDbInfo dbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        this.appendKeyValue(stringBuilder, "mysql-user", (Object)dbInfo.getUser());
        this.appendKeyValue(stringBuilder, "mysql-password", (Object)dbInfo.fetchPasswordPlainText());
        if (StringUtils.isNotBlank((String)dbInfo.getSysbenchDbName())) {
            this.appendKeyValue(stringBuilder, "mysql-db", (Object)dbInfo.getSysbenchDbName());
        }
        if (dbInfo.isLoadBalance()) {
            LoadBalanceAddr loadBalanceAddr = LoadBalanceAddr.parse((String)dbInfo.getLoadBalanceAddr());
            this.appendKeyValue(stringBuilder, "mysql-host", (Object)loadBalanceAddr.getFormattedHost());
            this.appendKeyValue(stringBuilder, "mysql-port", (Object)loadBalanceAddr.getFormattedPort());
        } else {
            this.appendKeyValue(stringBuilder, "mysql-host", (Object)dbInfo.getHost());
            this.appendKeyValue(stringBuilder, "mysql-port", (Object)dbInfo.getPort().toString());
        }
    }

    protected void appendKeyValue(StringBuilder stringBuilder, String key, Object value) {
        stringBuilder.append("--").append(key).append("='").append(value).append("' ");
    }

    @NotNull
    public int getTables() {
        return this.tables;
    }

    @NotNull
    public int getTableSize() {
        return this.tableSize;
    }

    @NotNull
    public int getThreads() {
        return this.threads;
    }

    public String getDb() {
        return this.db;
    }

    public int getRangeSize() {
        return this.rangeSize;
    }

    public boolean isDbPsMode() {
        return this.dbPsMode;
    }

    public boolean isSkipTrx() {
        return this.skipTrx;
    }

    public boolean isPrintHistogram() {
        return this.printHistogram;
    }

    public int getReportInterval() {
        return this.reportInterval;
    }

    public String getIgnoreErrors() {
        return this.ignoreErrors;
    }

    @NotNull(message="\u8d1f\u8f7d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    public @NotNull(message="\u8d1f\u8f7d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String getWorkload() {
        return this.workload;
    }

    public int getTime() {
        return this.time;
    }

    public String getCommand() {
        return this.command;
    }

    public void setDb(String db) {
        this.db = db;
    }

    public void setRangeSize(int rangeSize) {
        this.rangeSize = rangeSize;
    }

    public void setDbPsMode(boolean dbPsMode) {
        this.dbPsMode = dbPsMode;
    }

    public void setSkipTrx(boolean skipTrx) {
        this.skipTrx = skipTrx;
    }

    public void setPrintHistogram(boolean printHistogram) {
        this.printHistogram = printHistogram;
    }

    public void setReportInterval(int reportInterval) {
        this.reportInterval = reportInterval;
    }

    public void setIgnoreErrors(String ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SysbenchProperty)) {
            return false;
        }
        SysbenchProperty other = (SysbenchProperty)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getTables() != other.getTables()) {
            return false;
        }
        if (this.getTableSize() != other.getTableSize()) {
            return false;
        }
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getRangeSize() != other.getRangeSize()) {
            return false;
        }
        if (this.isDbPsMode() != other.isDbPsMode()) {
            return false;
        }
        if (this.isSkipTrx() != other.isSkipTrx()) {
            return false;
        }
        if (this.isPrintHistogram() != other.isPrintHistogram()) {
            return false;
        }
        if (this.getReportInterval() != other.getReportInterval()) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        String this$db = this.getDb();
        String other$db = other.getDb();
        if (this$db == null ? other$db != null : !this$db.equals(other$db)) {
            return false;
        }
        String this$ignoreErrors = this.getIgnoreErrors();
        String other$ignoreErrors = other.getIgnoreErrors();
        if (this$ignoreErrors == null ? other$ignoreErrors != null : !this$ignoreErrors.equals(other$ignoreErrors)) {
            return false;
        }
        String this$workload = this.getWorkload();
        String other$workload = other.getWorkload();
        if (this$workload == null ? other$workload != null : !this$workload.equals(other$workload)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        return !(this$command == null ? other$command != null : !this$command.equals(other$command));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SysbenchProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTables();
        result = result * 59 + this.getTableSize();
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getRangeSize();
        result = result * 59 + (this.isDbPsMode() ? 79 : 97);
        result = result * 59 + (this.isSkipTrx() ? 79 : 97);
        result = result * 59 + (this.isPrintHistogram() ? 79 : 97);
        result = result * 59 + this.getReportInterval();
        result = result * 59 + this.getTime();
        String $db = this.getDb();
        result = result * 59 + ($db == null ? 43 : $db.hashCode());
        String $ignoreErrors = this.getIgnoreErrors();
        result = result * 59 + ($ignoreErrors == null ? 43 : $ignoreErrors.hashCode());
        String $workload = this.getWorkload();
        result = result * 59 + ($workload == null ? 43 : $workload.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        return result;
    }

    public String toString() {
        return "SysbenchProperty(tables=" + this.getTables() + ", tableSize=" + this.getTableSize() + ", threads=" + this.getThreads() + ", db=" + this.getDb() + ", rangeSize=" + this.getRangeSize() + ", dbPsMode=" + this.isDbPsMode() + ", skipTrx=" + this.isSkipTrx() + ", printHistogram=" + this.isPrintHistogram() + ", reportInterval=" + this.getReportInterval() + ", ignoreErrors=" + this.getIgnoreErrors() + ", workload=" + this.getWorkload() + ", time=" + this.getTime() + ", command=" + this.getCommand() + ")";
    }
}

