/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.entity.TpccRunInfo;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class TpccProperty
extends BaseRunProperty {
    private static final int DEFAULT_RUN_TIME_MINUTE = 5;
    @NotNull
    @Min(value=1L, message="\u4ed3\u6570\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u4ed3\u6570\u4e0d\u80fd\u5c0f\u4e8e1") int warehouses;
    @NotNull
    @Min(value=1L, message="\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1") int threads;
    @Min(value=1L, message="\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e1min")
    private @Min(value=1L, message="\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e1min") int timeMins;
    private int newOrderRemotePercent;
    private int paymentRemotePercent;
    public static final String NEW_ORDER_REMOTE_KEY = "newOrderRemotePercent";
    public static final String PAYMENT_REMOTE_KEY = "paymentRemotePercent";
    private boolean saveTrxRt;
    public static final String SAVE_TRX_RT_KEY = "saveTrxRt";
    private boolean useStoredProcedure;
    public static final String USE_STORED_PROCEDURE_KEY = "useStoredProcedure";

    protected TpccProperty(int warehouses, int threads) {
        this.warehouses = warehouses;
        this.threads = threads;
    }

    protected TpccProperty(JSONObject propertyMap) {
        this(propertyMap.getIntValue("warehouses"), propertyMap.getIntValue("threads"));
        this.timeMins = (Integer)propertyMap.getOrDefault((Object)"time", (Object)5);
        this.newOrderRemotePercent = (Integer)propertyMap.getOrDefault((Object)"newOrderRemotePercent", (Object)10);
        this.paymentRemotePercent = (Integer)propertyMap.getOrDefault((Object)"paymentRemotePercent", (Object)15);
        this.saveTrxRt = (Boolean)propertyMap.getOrDefault((Object)"saveTrxRt", (Object)false);
        this.useStoredProcedure = (Boolean)propertyMap.getOrDefault((Object)"useStoredProcedure", (Object)false);
    }

    public static TpccProperty from(JSONObject propertyMap) {
        return new TpccProperty(propertyMap);
    }

    public static TpccProperty from(TpccRunInfo runInfo) {
        TpccProperty tpccProperty = new TpccProperty(runInfo.getWarehouses(), runInfo.getThreads());
        tpccProperty.setTimeMins(runInfo.getTimeMinutes());
        try {
            JSONObject jsonObject = JSON.parseObject((String)runInfo.getExtra());
            tpccProperty.setNewOrderRemotePercent(((Integer)jsonObject.getOrDefault((Object)"newOrderRemotePercent", (Object)10)).intValue());
            tpccProperty.setPaymentRemotePercent(((Integer)jsonObject.getOrDefault((Object)"paymentRemotePercent", (Object)15)).intValue());
            tpccProperty.setSaveTrxRt(((Boolean)jsonObject.getOrDefault((Object)"saveTrxRt", (Object)false)).booleanValue());
            tpccProperty.setUseStoredProcedure(((Boolean)jsonObject.getOrDefault((Object)"useStoredProcedure", (Object)false)).booleanValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            tpccProperty.setNewOrderRemotePercent(10);
            tpccProperty.setPaymentRemotePercent(15);
            tpccProperty.setSaveTrxRt(false);
            tpccProperty.setUseStoredProcedure(false);
        }
        return tpccProperty;
    }

    public void runValidate() {
        if (this.timeMins > 300 && this.saveTrxRt) {
            throw new UnsupportedOperationException("Do not support saving trx rt over 300-minute running time");
        }
    }

    public void prepareValidate() {
        if (this.threads > this.warehouses + 1) {
            throw new IllegalArgumentException(this.threads + " loadWorkers is too many for warehouses: " + this.warehouses);
        }
        double freeMemGb = -1.0;
        try {
            freeMemGb = (double)ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class).getTotalPhysicalMemorySize() / 1.073741824E9;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (freeMemGb > 0.0) {
            if (freeMemGb <= 2.0 && this.threads > 10) {
                TpccProperty.tooManyThreadsForImport((double)freeMemGb, (int)this.threads);
            }
            if ((double)this.threads > freeMemGb * 10.0) {
                TpccProperty.tooManyThreadsForImport((double)freeMemGb, (int)this.threads);
            }
        }
    }

    private static void tooManyThreadsForImport(double freeMemGb, int threads) {
        throw new IllegalArgumentException(String.format("Not enough free memory[%.2f GB] for loadWorkers: %d", freeMemGb, threads));
    }

    @NotNull
    public int getWarehouses() {
        return this.warehouses;
    }

    @NotNull
    public int getThreads() {
        return this.threads;
    }

    public int getTimeMins() {
        return this.timeMins;
    }

    public int getNewOrderRemotePercent() {
        return this.newOrderRemotePercent;
    }

    public int getPaymentRemotePercent() {
        return this.paymentRemotePercent;
    }

    public boolean isSaveTrxRt() {
        return this.saveTrxRt;
    }

    public boolean isUseStoredProcedure() {
        return this.useStoredProcedure;
    }

    public void setTimeMins(int timeMins) {
        this.timeMins = timeMins;
    }

    public void setNewOrderRemotePercent(int newOrderRemotePercent) {
        this.newOrderRemotePercent = newOrderRemotePercent;
    }

    public void setPaymentRemotePercent(int paymentRemotePercent) {
        this.paymentRemotePercent = paymentRemotePercent;
    }

    public void setSaveTrxRt(boolean saveTrxRt) {
        this.saveTrxRt = saveTrxRt;
    }

    public void setUseStoredProcedure(boolean useStoredProcedure) {
        this.useStoredProcedure = useStoredProcedure;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TpccProperty)) {
            return false;
        }
        TpccProperty other = (TpccProperty)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getWarehouses() != other.getWarehouses()) {
            return false;
        }
        if (this.getThreads() != other.getThreads()) {
            return false;
        }
        if (this.getTimeMins() != other.getTimeMins()) {
            return false;
        }
        if (this.getNewOrderRemotePercent() != other.getNewOrderRemotePercent()) {
            return false;
        }
        if (this.getPaymentRemotePercent() != other.getPaymentRemotePercent()) {
            return false;
        }
        if (this.isSaveTrxRt() != other.isSaveTrxRt()) {
            return false;
        }
        return this.isUseStoredProcedure() == other.isUseStoredProcedure();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TpccProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWarehouses();
        result = result * 59 + this.getThreads();
        result = result * 59 + this.getTimeMins();
        result = result * 59 + this.getNewOrderRemotePercent();
        result = result * 59 + this.getPaymentRemotePercent();
        result = result * 59 + (this.isSaveTrxRt() ? 79 : 97);
        result = result * 59 + (this.isUseStoredProcedure() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "TpccProperty(warehouses=" + this.getWarehouses() + ", threads=" + this.getThreads() + ", timeMins=" + this.getTimeMins() + ", newOrderRemotePercent=" + this.getNewOrderRemotePercent() + ", paymentRemotePercent=" + this.getPaymentRemotePercent() + ", saveTrxRt=" + this.isSaveTrxRt() + ", useStoredProcedure=" + this.isUseStoredProcedure() + ")";
    }
}

