/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.model.ServerConstants;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import java.util.Iterator;
import javax.validation.ConstraintViolation;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.lang.Nullable;

public class TpchPrepareProperty
extends BaseRunProperty {
    @Min(value=1L, message="\u6570\u636e\u96c6\u89c4\u6a21\u4e0d\u80fd\u5c0f\u4e8e1GB")
    @Max(value=1000L, message="\u6570\u636e\u96c6\u89c4\u6a21\u6682\u4e0d\u652f\u6301\u8d85\u8fc71TB")
    private @Min(value=1L, message="\u6570\u636e\u96c6\u89c4\u6a21\u4e0d\u80fd\u5c0f\u4e8e1GB") @Max(value=1000L, message="\u6570\u636e\u96c6\u89c4\u6a21\u6682\u4e0d\u652f\u6301\u8d85\u8fc71TB") int gb;
    @Nullable
    @Min(value=8L, message="\u5206\u7247\u6570\u4e0d\u80fd\u5c0f\u4e8e8")
    @Max(value=4096L, message="\u5206\u7247\u6570\u4e0d\u80fd\u8d85\u8fc74096")
    private @Min(value=8L, message="\u5206\u7247\u6570\u4e0d\u80fd\u5c0f\u4e8e8") @Max(value=4096L, message="\u5206\u7247\u6570\u4e0d\u80fd\u8d85\u8fc74096") Integer partitions;
    @Min(value=0L, message="\u5e76\u53d1\u5ea6\u4e0d\u80fd\u4f4e\u4e8e0")
    private @Min(value=0L, message="\u5e76\u53d1\u5ea6\u4e0d\u80fd\u4f4e\u4e8e0") int parallelism;
    private boolean skipCreateTable = false;

    public static TpchPrepareProperty from(JSONObject propertyMap) {
        TpchPrepareProperty tpchPrepareProperty = new TpchPrepareProperty();
        tpchPrepareProperty.setGb(propertyMap.getIntValue("gb"));
        tpchPrepareProperty.setPartitions(propertyMap.getInteger("partitions"));
        tpchPrepareProperty.setParallelism(((Integer)propertyMap.getOrDefault((Object)"threads", (Object)0)).intValue());
        tpchPrepareProperty.setSkipCreateTable(((Boolean)propertyMap.getOrDefault((Object)"skipCreateTable", (Object)false)).booleanValue());
        return tpchPrepareProperty;
    }

    public void prepareValidate() {
        Iterator iterator = ServerConstants.VALIDATOR.validate((Object)this, new Class[0]).iterator();
        if (iterator.hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            throw new IllegalArgumentException(violation.getMessage());
        }
    }

    public int getGb() {
        return this.gb;
    }

    @Nullable
    public Integer getPartitions() {
        return this.partitions;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public boolean isSkipCreateTable() {
        return this.skipCreateTable;
    }

    public void setGb(int gb) {
        this.gb = gb;
    }

    public void setPartitions(@Nullable Integer partitions) {
        this.partitions = partitions;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void setSkipCreateTable(boolean skipCreateTable) {
        this.skipCreateTable = skipCreateTable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TpchPrepareProperty)) {
            return false;
        }
        TpchPrepareProperty other = (TpchPrepareProperty)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getGb() != other.getGb()) {
            return false;
        }
        if (this.getParallelism() != other.getParallelism()) {
            return false;
        }
        if (this.isSkipCreateTable() != other.isSkipCreateTable()) {
            return false;
        }
        Integer this$partitions = this.getPartitions();
        Integer other$partitions = other.getPartitions();
        return !(this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TpchPrepareProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getGb();
        result = result * 59 + this.getParallelism();
        result = result * 59 + (this.isSkipCreateTable() ? 79 : 97);
        Integer $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        return result;
    }

    public String toString() {
        return "TpchPrepareProperty(gb=" + this.getGb() + ", partitions=" + this.getPartitions() + ", parallelism=" + this.getParallelism() + ", skipCreateTable=" + this.isSkipCreateTable() + ")";
    }
}

