/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.model.benchmark.QueryIdWithHint;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TpchQueryHintMap {
    public static final int ALL_QUERY_ID = 0;
    private final Map<Integer, String> queryHintMap = new HashMap(32);
    private final List<QueryIdWithHint> queryIdWithHints = new ArrayList(22);
    private String baseHint = "";
    private String jsonStrCache = null;
    private static final char[] ILLEGAL_CHARS = new char[]{'/', '*'};

    public TpchQueryHintMap(JSONArray queryHints, boolean allQueries) {
        int i;
        if (queryHints == null) {
            return;
        }
        for (i = 0; i < queryHints.size(); ++i) {
            JSONObject jsonObject = queryHints.getJSONObject(i);
            int queryId = this.getQueryId(jsonObject);
            String hint = this.getHint(jsonObject);
            if (StringUtils.containsAny((String)hint, (char[])ILLEGAL_CHARS)) {
                throw new IllegalArgumentException("Illegal chars in hint");
            }
            if (queryId == 0) {
                this.baseHint = hint;
                continue;
            }
            hint = this.mergeHintWithBase(hint);
            this.queryHintMap.put(queryId, hint);
            if (allQueries) continue;
            this.queryIdWithHints.add(new QueryIdWithHint(queryId, hint));
        }
        if (allQueries) {
            for (i = 1; i <= 22; ++i) {
                this.queryIdWithHints.add(new QueryIdWithHint(i, this.getHint(i)));
            }
        }
    }

    public String toJsonStr() {
        if (this.jsonStrCache != null) {
            return this.jsonStrCache;
        }
        this.jsonStrCache = JSONArray.toJSONString((Object)this.queryIdWithHints);
        return this.jsonStrCache;
    }

    public boolean containsId(int queryId) {
        return this.queryHintMap.containsKey(queryId);
    }

    public String getHint(int queryId) {
        return this.queryHintMap.getOrDefault(queryId, this.baseHint);
    }

    private String mergeHintWithBase(String hint) {
        if (this.baseHint.isEmpty()) {
            return hint;
        }
        if (hint == null) {
            return this.baseHint;
        }
        return this.baseHint + " " + hint;
    }

    private int getQueryId(JSONObject jsonObject) {
        return jsonObject.getIntValue("queryId");
    }

    private String getHint(JSONObject jsonObject) {
        return (String)jsonObject.getOrDefault((Object)"hint", (Object)"");
    }
}

