/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.model.bo;

import com.alibaba.fastjson.JSONObject;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class TransferProperty
extends BaseRunProperty {
    private static final int DEFAULT_RUN_TIME_SECOND = 1800;
    public static final int DISABLE_THREADS = 0;
    @NotNull
    @Min(value=0L, message="\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e0")
    private final @NotNull @Min(value=0L, message="\u4f59\u989d\u4e0d\u80fd\u5c0f\u4e8e0") int balance;
    @NotNull
    @Min(value=1L, message="\u591a\u5c11\u4e2a\u8d26\u6237")
    private final @NotNull @Min(value=1L, message="\u591a\u5c11\u4e2a\u8d26\u6237") int tableSize;
    @NotNull
    @Min(value=1L, message="\u8f6c\u8d26\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u8f6c\u8d26\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1") int simpleThreads;
    @NotNull
    @Min(value=1L, message="\u4f59\u989d\u6821\u9a8c\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1")
    private final @NotNull @Min(value=1L, message="\u4f59\u989d\u6821\u9a8c\u5e76\u53d1\u5ea6\u4e0d\u80fd\u5c0f\u4e8e1") int checkBalanceThreads;
    private int replicaThreads;
    private int replicaSessionHintThreads;
    private int flashbackThreads;
    private int replicaFlashbackThreads;
    @Min(value=0L, message="\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0s")
    private @Min(value=0L, message="\u8fd0\u884c\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e0s") int time;

    protected TransferProperty(int balance, int tableSize, int simpleThreads, int checkBalanceThreads) {
        this.balance = balance;
        this.tableSize = tableSize;
        this.simpleThreads = simpleThreads;
        this.checkBalanceThreads = checkBalanceThreads;
    }

    protected TransferProperty(JSONObject propertyMap) {
        this(propertyMap.getIntValue("balance"), propertyMap.getIntValue("tableSize"), propertyMap.getIntValue("simpleThreads"), propertyMap.getIntValue("checkBalanceThreads"));
        this.time = (Integer)propertyMap.getOrDefault((Object)"time", (Object)1800);
        this.replicaThreads = (Integer)propertyMap.getOrDefault((Object)"replicaThreads", (Object)0);
        this.replicaSessionHintThreads = (Integer)propertyMap.getOrDefault((Object)"replicaSessionHintThreads", (Object)0);
        this.flashbackThreads = (Integer)propertyMap.getOrDefault((Object)"flashbackThreads", (Object)0);
        this.replicaFlashbackThreads = (Integer)propertyMap.getOrDefault((Object)"replicaFlashbackThreads", (Object)0);
    }

    public static TransferProperty from(JSONObject propertyMap) {
        return new TransferProperty(propertyMap);
    }

    public void runValidate() {
        if (this.time > 0 && this.time < 30) {
            throw new UnsupportedOperationException("Do not support less than 30-second running time");
        }
    }

    @NotNull
    public int getBalance() {
        return this.balance;
    }

    @NotNull
    public int getTableSize() {
        return this.tableSize;
    }

    @NotNull
    public int getSimpleThreads() {
        return this.simpleThreads;
    }

    @NotNull
    public int getCheckBalanceThreads() {
        return this.checkBalanceThreads;
    }

    public int getReplicaThreads() {
        return this.replicaThreads;
    }

    public int getReplicaSessionHintThreads() {
        return this.replicaSessionHintThreads;
    }

    public int getFlashbackThreads() {
        return this.flashbackThreads;
    }

    public int getReplicaFlashbackThreads() {
        return this.replicaFlashbackThreads;
    }

    public int getTime() {
        return this.time;
    }

    public void setReplicaThreads(int replicaThreads) {
        this.replicaThreads = replicaThreads;
    }

    public void setReplicaSessionHintThreads(int replicaSessionHintThreads) {
        this.replicaSessionHintThreads = replicaSessionHintThreads;
    }

    public void setFlashbackThreads(int flashbackThreads) {
        this.flashbackThreads = flashbackThreads;
    }

    public void setReplicaFlashbackThreads(int replicaFlashbackThreads) {
        this.replicaFlashbackThreads = replicaFlashbackThreads;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransferProperty)) {
            return false;
        }
        TransferProperty other = (TransferProperty)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getBalance() != other.getBalance()) {
            return false;
        }
        if (this.getTableSize() != other.getTableSize()) {
            return false;
        }
        if (this.getSimpleThreads() != other.getSimpleThreads()) {
            return false;
        }
        if (this.getCheckBalanceThreads() != other.getCheckBalanceThreads()) {
            return false;
        }
        if (this.getReplicaThreads() != other.getReplicaThreads()) {
            return false;
        }
        if (this.getReplicaSessionHintThreads() != other.getReplicaSessionHintThreads()) {
            return false;
        }
        if (this.getFlashbackThreads() != other.getFlashbackThreads()) {
            return false;
        }
        if (this.getReplicaFlashbackThreads() != other.getReplicaFlashbackThreads()) {
            return false;
        }
        return this.getTime() == other.getTime();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransferProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBalance();
        result = result * 59 + this.getTableSize();
        result = result * 59 + this.getSimpleThreads();
        result = result * 59 + this.getCheckBalanceThreads();
        result = result * 59 + this.getReplicaThreads();
        result = result * 59 + this.getReplicaSessionHintThreads();
        result = result * 59 + this.getFlashbackThreads();
        result = result * 59 + this.getReplicaFlashbackThreads();
        result = result * 59 + this.getTime();
        return result;
    }

    public String toString() {
        return "TransferProperty(balance=" + this.getBalance() + ", tableSize=" + this.getTableSize() + ", simpleThreads=" + this.getSimpleThreads() + ", checkBalanceThreads=" + this.getCheckBalanceThreads() + ", replicaThreads=" + this.getReplicaThreads() + ", replicaSessionHintThreads=" + this.getReplicaSessionHintThreads() + ", flashbackThreads=" + this.getFlashbackThreads() + ", replicaFlashbackThreads=" + this.getReplicaFlashbackThreads() + ", time=" + this.getTime() + ")";
    }
}

