/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.impl;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.exception.LogNotFoundException;
import com.polarx.benchmarkboot.model.BenchmarkStatus;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.LogicalDbInfo;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageBuilder;
import com.polarx.benchmarkboot.model.dto.rsp.ValidateDatasetRsp;
import com.polarx.benchmarkboot.service.IBenchmarkService;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.util.JdbcUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class BaseBenchmarkService
implements IBenchmarkService {
    private static final Logger log = LoggerFactory.getLogger(BaseBenchmarkService.class);
    protected final PathConfigConstant pathConfigConstant;
    protected final BenchmarkAccessor accessor;

    protected BaseBenchmarkService(PathConfigConstant pathConfigConstant, BenchmarkAccessor accessor) {
        this.pathConfigConstant = pathConfigConstant;
        this.accessor = accessor;
    }

    public void setIdle() {
        this.accessor.setIdle();
    }

    public void updateDbInfo(BenchmarkDbInfo dbInfo) {
        try {
            this.accessor.update(dbInfo);
        }
        catch (Exception e) {
            log.error("Failed to update {} config: {}", (Object)this.getBenchmarkName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        log.info("{} db info file update successfully", (Object)this.getBenchmarkName());
    }

    public void updateDbInfo(BenchmarkDbInfo dbInfo, LogicalDbInfo newDbInfo) {
        this.updateByNewDbInfo(dbInfo, newDbInfo);
        this.updateDbInfo(dbInfo);
    }

    protected abstract void updateByNewDbInfo(BenchmarkDbInfo var1, LogicalDbInfo var2);

    public void prepare(BaseRunProperty property, RunningContext context) {
        try {
            this.beforePrepare();
            this.accessor.prepare(property, context);
        }
        catch (Exception e) {
            log.error("Failed to prepare {}: {}", (Object)this.getBenchmarkName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void beforePrepare() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        JdbcUtil.setVarBeforeLoadData((BenchmarkDbInfo)benchmarkDbInfo, (CreateDbMode)this.accessor.getDbMode(benchmarkDbInfo));
    }

    public void beforeRunCheck() {
        this.accessor.beforeRunCheck();
    }

    public BenchmarkStatus getStatus() {
        return this.accessor.getStatus();
    }

    public void stop() {
        try {
            this.accessor.stop();
        }
        catch (Exception e) {
            log.error("Failed to stop {}: {}", (Object)this.getBenchmarkName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            this.setIdle();
        }
        log.info("Stop {} successfully", (Object)this.getBenchmarkName());
    }

    public void warmup() {
    }

    public void runBenchmark(BaseRunProperty runProperty, RunningContext context) {
        try {
            this.accessor.run(runProperty, context);
        }
        catch (Exception e) {
            log.error("Failed to run {}: {}", (Object)this.getBenchmarkName(), (Object)e.getMessage());
            this.accessor.taskFailed(context);
            throw new RuntimeException(e);
        }
        log.info("Run {} successfully", (Object)this.getBenchmarkName());
    }

    public abstract QpsCompareResult compareResult(Integer var1, Integer var2);

    public CompareResult compareResult(List<Integer> idList) {
        this.idListCheck(idList);
        return this.compareResultInner(idList);
    }

    public abstract CompareResult compareResultInner(List<Integer> var1);

    @Transactional
    public void delete(List<Integer> idList) {
        this.idListCheck(idList);
        this.deleteInner(idList);
    }

    public abstract void deleteInner(List<Integer> var1);

    protected void idListCheck(List<Integer> idList) {
        if (idList == null) {
            throw new IllegalArgumentException("Empty id list");
        }
        if (idList.size() > 10) {
            throw new IllegalArgumentException("Batch delete more than 10");
        }
    }

    protected void checkTaskRunning(ILoggedBenchmarkRunInfo runInfo, Integer id) {
        if (runInfo == null) {
            throw new IllegalArgumentException("Cannot find result for Task-" + id);
        }
        if (runInfo.getStatus() != RunningStatus.RUNNING) {
            throw new IllegalStateException("Task is not in RUNNING state");
        }
    }

    protected File getAndCheckLogFile(ILoggedBenchmarkRunInfo runInfo, Integer id) {
        if (runInfo == null) {
            throw new IllegalArgumentException("Cannot find result for Task-" + id);
        }
        if (runInfo.getStatus() != RunningStatus.COMPLETED) {
            throw new IllegalStateException("Task is not in COMPLETED state");
        }
        if (runInfo.getLogFilePath() == null) {
            throw new LogNotFoundException("Cannot access log file for Task-" + id);
        }
        File logFile = new File(runInfo.getLogFilePath());
        if (!logFile.exists() || !logFile.canRead()) {
            throw new LogNotFoundException("Cannot access log file: " + runInfo.getLogFilePath());
        }
        return logFile;
    }

    public String getBenchmarkName() {
        return this.getType().getName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ValidateDatasetRsp validateDataset() {
        if (this.getStatus() != BenchmarkStatus.IDLE) {
            throw new IllegalStateException(this.getBenchmarkName() + " is in " + this.getStatus().name() + " state");
        }
        MultiLineMessageBuilder msgBuilder = new MultiLineMessageBuilder();
        BenchmarkDbInfo dbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)dbInfo, (String)dbInfo.getDbName(this.getType()));){
            ValidateDatasetRsp validateDatasetRsp;
            block16: {
                Statement stmt = conn.createStatement();
                try {
                    boolean success = this.validateTables(stmt, msgBuilder);
                    if (success) {
                        success = this.validateData(stmt, msgBuilder);
                    }
                    validateDatasetRsp = new ValidateDatasetRsp(msgBuilder.build(), success);
                    if (stmt == null) break block16;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return validateDatasetRsp;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract RunningContext getContext();

    protected abstract boolean validateTables(Statement var1, MultiLineMessageBuilder var2) throws SQLException;

    protected abstract boolean validateData(Statement var1, MultiLineMessageBuilder var2) throws SQLException;
}

