/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.impl;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.SysbenchRunInfo;
import com.polarx.benchmarkboot.exception.TaskNotFoundException;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.SysbenchContext;
import com.polarx.benchmarkboot.model.benchmark.SysbenchQpsProcessor;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.LogicalDbInfo;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageBuilder;
import com.polarx.benchmarkboot.repo.SysbenchRunRepository;
import com.polarx.benchmarkboot.service.ISysbenchBenchmark;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.util.Preconditions;
import com.polarx.benchmarkboot.util.StatUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"pathConfigConstant"})
public class SysbenchService
extends BaseBenchmarkService
implements ISysbenchBenchmark {
    private static final Logger log = LoggerFactory.getLogger(SysbenchService.class);
    @Resource
    private SysbenchRunRepository sysbenchRunRepository;
    private static final int MAX_QPS_RESULT_SIZE = 21600;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    @Autowired
    public SysbenchService(PathConfigConstant configConstant, BenchmarkAccessor sysbenchAccessor) {
        super(configConstant, sysbenchAccessor);
    }

    protected void updateByNewDbInfo(BenchmarkDbInfo dbInfo, LogicalDbInfo newDbInfo) {
        dbInfo.setSysbenchDbName(newDbInfo.getDbName());
        dbInfo.setSysbenchMode(newDbInfo.getDbMode());
    }

    protected boolean validateTables(Statement stmt, MultiLineMessageBuilder stringBuilder) throws SQLException {
        int maxTableId;
        int count;
        block14: {
            count = 0;
            maxTableId = -1;
            ResultSet rs = stmt.executeQuery("SHOW TABLES");
            block7: while (true) {
                while (rs.next()) {
                    String tableName = rs.getString(1);
                    if (!StringUtils.startsWith((String)tableName, (String)"sbtest")) continue;
                    try {
                        int tableId = Integer.parseInt(tableName.substring("sbtest".length()));
                        maxTableId = Math.max(maxTableId, tableId);
                        ++count;
                        continue block7;
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                }
                break block14;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        if (count == 0) {
            stringBuilder.appendLine("No tables matching [sbtest] in sysbench databases. ");
            return false;
        }
        if (count == maxTableId) {
            stringBuilder.appendLine(String.format("Sysbench table count: %d. ", count));
            return true;
        }
        if (count < maxTableId) {
            stringBuilder.appendLine(String.format("Sysbench table count [%d] is less than max table id [%d]. ", count, maxTableId));
        } else {
            stringBuilder.appendLine(String.format("Sysbench table count [%d] is more than max table id [%d]. ", count, maxTableId));
        }
        return false;
    }

    protected boolean validateData(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        try (ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM sbtest1");){
            rs.next();
            int tableSize = rs.getInt(1);
            result.appendLine(String.format("Checked [sbtest1] table size: %d. ", tableSize));
        }
        return true;
    }

    public List<QpsDataRecord> getQpsResultList(SysbenchRunInfo runInfo) {
        Preconditions.checkNotNull((Object)runInfo, (Object)"Sysbench run info is null");
        File logFile = this.getAndCheckLogFile((ILoggedBenchmarkRunInfo)runInfo, runInfo.getId());
        Date createdAt = runInfo.getCreatedAt();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createdAt);
        calendar.add(13, 1);
        SysbenchQpsProcessor qpsProcessor = new SysbenchQpsProcessor();
        ArrayList<QpsDataRecord> qpsDataRecordList = new ArrayList<QpsDataRecord>();
        try (BufferedReader logReader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));){
            String line = null;
            while ((line = logReader.readLine()) != null) {
                Float qps = qpsProcessor.processQps(line);
                if (qps == null) continue;
                qpsDataRecordList.add(new QpsDataRecord(this.dateFormat.format(calendar.getTime()), "QPS", qps));
                if (qpsDataRecordList.size() >= 21600) {
                    break;
                }
                calendar.add(13, 1);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return qpsDataRecordList;
    }

    private List<QpsDataRecord> getRealtimeQpsResultList(SysbenchRunInfo runInfo) {
        SimpleDateFormat localDateFormat = new SimpleDateFormat("HH:mm:ss");
        Preconditions.checkNotNull((Object)runInfo, (Object)"Sysbench run info is null");
        this.checkTaskRunning((ILoggedBenchmarkRunInfo)runInfo, runInfo.getId());
        Queue realtimeQpsQueue = this.getContext().getRealtimeQpsQueue();
        if (realtimeQpsQueue.isEmpty()) {
            return null;
        }
        Date createdAt = runInfo.getCreatedAt();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(createdAt);
        SysbenchQpsProcessor qpsProcessor = (SysbenchQpsProcessor)this.getContext().getRealtimeQpsProcessor();
        ArrayList<QpsDataRecord> qpsDataRecords = new ArrayList<QpsDataRecord>(realtimeQpsQueue);
        int curLine = qpsProcessor.getCurLine();
        int secondOffset = 1;
        if (qpsDataRecords.size() >= 3600) {
            secondOffset += curLine - 3600;
        }
        calendar.add(13, secondOffset);
        for (QpsDataRecord qpsDataRecord : qpsDataRecords) {
            qpsDataRecord.setDate(localDateFormat.format(calendar.getTime()));
            calendar.add(13, 1);
        }
        return qpsDataRecords;
    }

    public List<QpsDataRecord> getQpsResultList(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null");
        SysbenchRunInfo runInfo = this.sysbenchRunRepository.findById(id);
        return this.getQpsResultList(runInfo);
    }

    public List<QpsDataRecord> getRealtimeQpsResultList(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null");
        SysbenchRunInfo runInfo = this.sysbenchRunRepository.findById(id);
        return this.getRealtimeQpsResultList(runInfo);
    }

    public QpsCompareResult<SysbenchRunInfo> compareResult(Integer id1, Integer id2) {
        SysbenchRunInfo task1 = this.getNonNullRunInfo(id1);
        SysbenchRunInfo task2 = this.getNonNullRunInfo(id2);
        List qpsResultList1 = this.getQpsResultList(task1);
        List qpsResultList2 = this.getQpsResultList(task2);
        List qpsList = StatUtil.mergeQpsList((List)qpsResultList1, (Integer)id1, (List)qpsResultList2, (Integer)id2, (String)"QPS");
        QpsCompareResult result = new QpsCompareResult(qpsList);
        result.setTask1((ILoggedBenchmarkRunInfo)task1);
        result.setTask2((ILoggedBenchmarkRunInfo)task2);
        return result;
    }

    public CompareResult<SysbenchRunInfo> compareResultInner(List<Integer> idList) {
        CompareResult result = new CompareResult();
        idList.forEach(id -> {
            SysbenchRunInfo task = this.getNonNullRunInfo(id);
            result.addResult((ILoggedBenchmarkRunInfo)task);
        });
        return result;
    }

    public void deleteInner(List<Integer> idList) {
        log.info("Deleting sysbench task: {}", idList);
        this.sysbenchRunRepository.deleteByIdList(idList);
    }

    public RunningContext getContext() {
        return SysbenchContext.getInstance();
    }

    public SysbenchRunInfo getNonNullRunInfo(Integer id) {
        SysbenchRunInfo runInfo = this.sysbenchRunRepository.findById(id);
        if (runInfo == null) {
            throw new TaskNotFoundException("Task-" + id + " cannot be found");
        }
        return runInfo;
    }
}

