/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.impl;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.TpccRunInfo;
import com.polarx.benchmarkboot.exception.LogNotFoundException;
import com.polarx.benchmarkboot.exception.TaskNotFoundException;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TpccContext;
import com.polarx.benchmarkboot.model.benchmark.TpccTpmcProcessor;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.LogicalDbInfo;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageBuilder;
import com.polarx.benchmarkboot.repo.TpccRunRepository;
import com.polarx.benchmarkboot.service.ITpccBenchmark;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.service.worker.TpccAccessor;
import com.polarx.benchmarkboot.util.Preconditions;
import com.polarx.benchmarkboot.util.StatUtil;
import com.polarx.benchmarkboot.util.TpccUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"pathConfigConstant"})
public class TpccService
extends BaseBenchmarkService
implements ITpccBenchmark {
    private static final Logger log = LoggerFactory.getLogger(TpccService.class);
    @Resource
    private TpccRunRepository tpccRunRepository;
    private static final int MAX_TPMC_RESULT_SIZE = 3600;

    @Autowired
    public TpccService(PathConfigConstant configConstant, BenchmarkAccessor tpccAccessor) {
        super(configConstant, tpccAccessor);
    }

    protected void updateByNewDbInfo(BenchmarkDbInfo dbInfo, LogicalDbInfo newDbInfo) {
        dbInfo.setTpccDbName(newDbInfo.getDbName());
        dbInfo.setTpccMode(newDbInfo.getDbMode());
    }

    protected boolean validateTables(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        HashSet tableNameSet = new HashSet(TpccUtil.TABLE_NAMES);
        try (ResultSet rs = stmt.executeQuery("SHOW TABLES");){
            while (rs.next()) {
                tableNameSet.remove(rs.getString(1));
            }
        }
        if (tableNameSet.isEmpty()) {
            result.appendLine("All tables exist. ");
            return true;
        }
        result.appendLine(String.format("Missing tables: [%s]. ", String.join((CharSequence)",", tableNameSet)));
        return false;
    }

    protected boolean validateData(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        int expectedWarehouse;
        try (ResultSet rs = stmt.executeQuery("select cfg_value from bmsql_config where cfg_name='warehouses'");){
            if (!rs.next()) {
                throw new RuntimeException("Missing warehouse config");
            }
            expectedWarehouse = rs.getInt(1);
        }
        rs = stmt.executeQuery("SELECT COUNT(*) FROM bmsql_warehouse");
        try {
            rs.next();
            int warehouse = rs.getInt(1);
            if (warehouse != expectedWarehouse) {
                result.appendLine(String.format("Expect %d warehouses, actually got %d from bmsql_warehouse. ", expectedWarehouse, warehouse));
                boolean bl = false;
                return bl;
            }
            result.appendLine(String.format("Warehouse count: %d is correct. ", expectedWarehouse));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        for (String validateSql : TpccUtil.VALIDATE_SQLS) {
            ResultSet rs = stmt.executeQuery(validateSql);
            try {
                if (!rs.next()) continue;
                result.appendLine("Dataset is incorrect, please check manually. ");
                boolean bl = false;
                return bl;
            }
            finally {
                if (rs == null) continue;
                rs.close();
            }
        }
        result.appendLine("Dataset is complete. ");
        return true;
    }

    public QpsCompareResult<TpccRunInfo> compareResult(Integer id1, Integer id2) {
        TpccRunInfo task1 = this.getNonNullRunInfo(id1);
        TpccRunInfo task2 = this.getNonNullRunInfo(id2);
        List qpsResultList1 = this.getTpmcResultList(task1);
        List qpsResultList2 = this.getTpmcResultList(task2);
        List qpsList = StatUtil.mergeQpsList((List)qpsResultList1, (Integer)id1, (List)qpsResultList2, (Integer)id2, (String)"tpmC");
        QpsCompareResult result = new QpsCompareResult(qpsList);
        result.setTask1((ILoggedBenchmarkRunInfo)task1);
        result.setTask2((ILoggedBenchmarkRunInfo)task2);
        return result;
    }

    public CompareResult<TpccRunInfo> compareResultInner(List<Integer> idList) {
        CompareResult result = new CompareResult();
        idList.forEach(id -> {
            TpccRunInfo task = this.getNonNullRunInfo(id);
            result.addResult((ILoggedBenchmarkRunInfo)task);
        });
        return result;
    }

    public void deleteInner(List<Integer> idList) {
        this.tpccRunRepository.deleteByIdList(idList);
    }

    public RunningContext getContext() {
        return TpccContext.getInstance();
    }

    public String getTrxResponseTime(Integer id) {
        TpccRunInfo runInfo = this.getNonNullRunInfo(id);
        File myResultDir = this.getMyResultDir(runInfo.getId());
        MultiLineMessageBuilder result = new MultiLineMessageBuilder();
        ((TpccAccessor)this.accessor).processTrxRt(myResultDir, result);
        return result.build();
    }

    private File getMyResultDir(Integer id) {
        String myResultDirName = "my_result_" + id;
        String myResultDirPath = this.getRunAbsPath(myResultDirName);
        File myResultDir = new File(myResultDirPath);
        if (!myResultDir.exists() || !myResultDir.isDirectory()) {
            throw new LogNotFoundException("Response time result dir is not found: " + myResultDirPath);
        }
        return myResultDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File parseMyResultDir(File logFile) {
        String targetPattern = "resultDirectory=";
        String line = null;
        try (BufferedReader logReader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));){
            int idx;
            do {
                if ((line = logReader.readLine()) == null) throw new LogNotFoundException("Response time result dir is not found");
            } while ((idx = line.indexOf("resultDirectory=")) == -1);
            String myResultDirName = line.substring(idx + "resultDirectory=".length());
            String myResultDirPath = this.getRunAbsPath(myResultDirName);
            File myResultDir = new File(myResultDirPath);
            if (!myResultDir.exists()) throw new LogNotFoundException("Response time result dir is not found");
            if (!myResultDir.isDirectory()) {
                throw new LogNotFoundException("Response time result dir is not found");
            }
            File file = myResultDir;
            return file;
        }
        catch (FileNotFoundException e) {
            throw new LogNotFoundException("TPC-C log file is not found");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getRunAbsPath(String myResultDirName) {
        String tpccHome = this.pathConfigConstant.TPCC_HOME;
        return tpccHome + "/" + myResultDirName;
    }

    private List<QpsDataRecord> getTpmcResultList(TpccRunInfo runInfo) {
        Preconditions.checkNotNull((Object)runInfo, (Object)"TPC-C runInfo is null");
        File logFile = this.getAndCheckLogFile((ILoggedBenchmarkRunInfo)runInfo, runInfo.getId());
        ArrayList<QpsDataRecord> tpmcDataRecordList = new ArrayList<QpsDataRecord>();
        TpccTpmcProcessor tpmcProcessor = new TpccTpmcProcessor();
        try (BufferedReader logReader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));){
            String line = null;
            while ((line = logReader.readLine()) != null) {
                QpsDataRecord qpsRecord = tpmcProcessor.processLine(line);
                if (qpsRecord == null) continue;
                tpmcDataRecordList.add(qpsRecord);
                if (tpmcDataRecordList.size() < 3600) continue;
                break;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tpmcDataRecordList;
    }

    private TpccRunInfo getNonNullRunInfo(Integer id) {
        TpccRunInfo runInfo = this.tpccRunRepository.findById(id);
        if (runInfo == null) {
            throw new TaskNotFoundException("Task-" + id + " cannot be found");
        }
        return runInfo;
    }

    public List<QpsDataRecord> getTpmcResultList(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null");
        TpccRunInfo runInfo = this.tpccRunRepository.findById(id);
        return this.getTpmcResultList(runInfo);
    }

    public List<QpsDataRecord> getRealtimeQpsResultList(Integer id) {
        Preconditions.checkNotNull((Object)id, (Object)"Id cannot be null");
        TpccRunInfo runInfo = this.tpccRunRepository.findById(id);
        return this.getRealtimeQpsResultList(runInfo);
    }

    private List<QpsDataRecord> getRealtimeQpsResultList(TpccRunInfo runInfo) {
        Preconditions.checkNotNull((Object)runInfo, (Object)"TPC-C run info is null");
        this.checkTaskRunning((ILoggedBenchmarkRunInfo)runInfo, runInfo.getId());
        Queue realtimeQpsQueue = this.getContext().getRealtimeQpsQueue();
        if (realtimeQpsQueue.isEmpty()) {
            return null;
        }
        return new ArrayList<QpsDataRecord>(realtimeQpsQueue);
    }
}

