/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.impl;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.TpchRunInfo;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TpchContext;
import com.polarx.benchmarkboot.model.benchmark.TpchQuery;
import com.polarx.benchmarkboot.model.benchmark.TpchTableInfo;
import com.polarx.benchmarkboot.model.bo.ColoredPolarxPlanNode;
import com.polarx.benchmarkboot.model.bo.ComparePlanResult;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.LogicalDbInfo;
import com.polarx.benchmarkboot.model.bo.PolarxPlanNode;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageBuilder;
import com.polarx.benchmarkboot.repo.TpchRunRepository;
import com.polarx.benchmarkboot.service.ITpchBenchmark;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.util.JdbcUtil;
import com.polarx.benchmarkboot.util.TpchUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"pathConfigConstant"})
public class TpchService
extends BaseBenchmarkService
implements ITpchBenchmark {
    private static final Logger log = LoggerFactory.getLogger(TpchService.class);
    @Resource
    private TpchQuery tpchQuery;
    @Resource
    private TpchRunRepository tpchRunRepository;

    @Autowired
    public TpchService(PathConfigConstant configConstant, BenchmarkAccessor tpchAccessor) {
        super(configConstant, tpchAccessor);
    }

    protected void updateByNewDbInfo(BenchmarkDbInfo dbInfo, LogicalDbInfo newDbInfo) {
        dbInfo.setTpchDbName(newDbInfo.getDbName());
        dbInfo.setTpchMode(newDbInfo.getDbMode());
    }

    public QpsCompareResult compareResult(Integer id1, Integer id2) {
        throw new UnsupportedOperationException();
    }

    public CompareResult<TpchRunInfo> compareResultInner(List<Integer> idList) {
        List runInfoList = this.tpchRunRepository.findByIdList(idList);
        return new CompareResult(runInfoList);
    }

    public void deleteInner(List<Integer> idList) {
        this.tpchRunRepository.deleteByIdList(idList);
    }

    public RunningContext getContext() {
        return TpchContext.getInstance();
    }

    protected boolean validateTables(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        HashSet tableNameSet = new HashSet(TpchUtil.TABLE_NAMES);
        try (ResultSet rs = stmt.executeQuery("SHOW TABLES");){
            while (rs.next()) {
                tableNameSet.remove(rs.getString(1));
            }
        }
        if (tableNameSet.isEmpty()) {
            result.appendLine("All tables exist. ");
            return true;
        }
        result.appendLine(String.format("Missing tables: [%s]. ", String.join((CharSequence)",", tableNameSet)));
        return false;
    }

    protected boolean validateData(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        int scaleFactor;
        TpchTableInfo targetInfo = TpchTableInfo.SUPPLIER;
        try (ResultSet rs = stmt.executeQuery(String.format("SELECT COUNT(*) FROM `%s`", targetInfo.getName()));){
            rs.next();
            int size = rs.getInt(1);
            int baseSize = targetInfo.getSize(1);
            if (size % baseSize != 0 || size == 0) {
                result.appendLine(String.format("Table [%s] size is incorrect, expected %d * scaleFactor, but got %d. ", targetInfo.getName(), baseSize, size));
                boolean bl = false;
                return bl;
            }
            scaleFactor = size / baseSize;
        }
        for (TpchTableInfo tableInfo : TpchTableInfo.TABLE_INFOS) {
            if (this.checkTableSize(stmt, scaleFactor, tableInfo, result)) continue;
            return false;
        }
        return true;
    }

    private boolean checkTableSize(Statement stmt, int scaleFactor, TpchTableInfo table, MultiLineMessageBuilder result) throws SQLException {
        try (ResultSet rs = stmt.executeQuery(String.format("SELECT COUNT(*) FROM `%s`", table.getName()));){
            rs.next();
            int actualSize = rs.getInt(1);
            int expectedSize = table.getSize(scaleFactor);
            if (!table.isApproximateSize() && actualSize != expectedSize) {
                result.appendLine(String.format("Table [%s] size is incorrect, expected %d, but got %d. ", table.getName(), expectedSize, actualSize));
                boolean bl = false;
                return bl;
            }
            if (table.isApproximateSize() && (double)Math.abs(actualSize - expectedSize) > (double)expectedSize / 1000.0) {
                result.appendLine(String.format("Table [%s] size is incorrect, expected about %d, but got %d. ", table.getName(), expectedSize, actualSize));
                boolean bl = false;
                return bl;
            }
            result.appendLine(String.format("Table [%s] checked OK. ", table.getName()));
        }
        return true;
    }

    public List<PolarxPlanNode> getQueryPlan(int queryId, String hint) {
        String explainSqlWithHint = this.tpchQuery.getExplainSqlWithHint(queryId, hint);
        return this.explainTpchQuery(explainSqlWithHint);
    }

    public ComparePlanResult compareQueryPlan(int queryId, String hint1, String hint2) {
        ArrayList coloredPlan2;
        ArrayList coloredPlan1;
        List plan2;
        String explainSqlWithHint = this.tpchQuery.getExplainSqlWithHint(queryId, hint1);
        List plan1 = this.explainTpchQuery(explainSqlWithHint);
        String message = this.comparePlan(plan1, plan2 = this.explainTpchQuery(explainSqlWithHint = this.tpchQuery.getExplainSqlWithHint(queryId, hint2)), coloredPlan1 = new ArrayList(), coloredPlan2 = new ArrayList()) ? "same" : "different";
        return new ComparePlanResult(coloredPlan1, coloredPlan2, message);
    }

    private boolean comparePlan(List<PolarxPlanNode> plan1, List<PolarxPlanNode> plan2, List<ColoredPolarxPlanNode> coloredPlan1, List<ColoredPolarxPlanNode> coloredPlan2) {
        return false;
    }

    private List<PolarxPlanNode> explainTpchQuery(String queryWithHint) {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        ArrayList<PolarxPlanNode> planNodeList = new ArrayList<PolarxPlanNode>(16);
        try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)benchmarkDbInfo, (String)benchmarkDbInfo.getTpchDbName());
             Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(queryWithHint);){
            String line;
            if (!rs.next()) {
                log.warn("Unexpected empty explain result: {}", (Object)queryWithHint);
                throw new RuntimeException("Unexpected empty explain result");
            }
            while (!StringUtils.isEmpty((String)(line = rs.getString(1)))) {
                if (line.startsWith("HitCache")) {
                } else {
                    planNodeList.add(PolarxPlanNode.parseLine((String)line));
                    if (rs.next()) continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            log.error("Failed to exec: {}.", (Object)queryWithHint);
            throw new RuntimeException(e);
        }
        return planNodeList;
    }
}

