/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.impl;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.exception.HistoryNotSupportException;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TransferContext;
import com.polarx.benchmarkboot.model.bo.CompareResult;
import com.polarx.benchmarkboot.model.bo.LogicalDbInfo;
import com.polarx.benchmarkboot.model.bo.QpsCompareResult;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageBuilder;
import com.polarx.benchmarkboot.service.ITransferBenchmark;
import com.polarx.benchmarkboot.service.impl.BaseBenchmarkService;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"pathConfigConstant"})
public class TransferService
extends BaseBenchmarkService
implements ITransferBenchmark {
    private static final Logger log = LoggerFactory.getLogger(TransferService.class);

    @Autowired
    public TransferService(PathConfigConstant configConstant, BenchmarkAccessor transferAccessor) {
        super(configConstant, transferAccessor);
    }

    protected void updateByNewDbInfo(BenchmarkDbInfo dbInfo, LogicalDbInfo newDbInfo) {
        dbInfo.setTransferDbName(newDbInfo.getDbName());
        dbInfo.setTransferMode(newDbInfo.getDbMode());
    }

    protected boolean validateTables(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        boolean exist = false;
        try (ResultSet rs = stmt.executeQuery("SHOW TABLES");){
            while (rs.next()) {
                if (!"accounts".equalsIgnoreCase(rs.getString(1))) continue;
                exist = true;
                break;
            }
        }
        if (exist) {
            result.appendLine("[accounts] table exists. ");
            return true;
        }
        result.appendLine(String.format("Missing table: [%s]. ", "accounts"));
        return false;
    }

    protected boolean validateData(Statement stmt, MultiLineMessageBuilder result) throws SQLException {
        try (ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM accounts");){
            rs.next();
            int tableSize = rs.getInt(1);
            result.appendLine(String.format("Checked [%s] rows: %d. ", "accounts", tableSize));
        }
        rs = stmt.executeQuery("SELECT sum(balance) FROM accounts");
        try {
            rs.next();
            int sum = rs.getInt(1);
            result.appendLine(String.format("Checked sum(balance): %d. ", sum));
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return true;
    }

    public QpsCompareResult compareResult(Integer id1, Integer id2) {
        throw new HistoryNotSupportException();
    }

    public CompareResult compareResultInner(List<Integer> idList) {
        throw new HistoryNotSupportException();
    }

    public void deleteInner(List<Integer> idList) {
        throw new HistoryNotSupportException();
    }

    public RunningContext getContext() {
        return TransferContext.getInstance();
    }
}

