/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.model.benchmark.StreamingCommandLineOutput;
import java.util.Queue;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResultWorker
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(BaseResultWorker.class);
    protected volatile boolean exited = false;
    protected final Queue<String> logQueue;
    protected final Session session;
    private static final int DEFAULT_WAIT_TIMEOUT_MILLIS = 10000;
    private static final boolean PARSE_OUTPUT = false;
    private int timePoint = 1;
    StreamingCommandLineOutput commandLineOutput;
    protected int waitTimeoutMillis = 10000;

    protected BaseResultWorker(StreamingCommandLineOutput commandLineOutput, Session session) {
        this.commandLineOutput = commandLineOutput;
        this.logQueue = commandLineOutput.getLogQueue();
        this.session = session;
    }

    @Override
    public void run() {
        block9: {
            if (this.commandLineOutput.getLastOutputLine() != null) {
                try {
                    this.session.getBasicRemote().sendText(this.commandLineOutput.getLastOutputLine() + "\n");
                    this.commandLineOutput.setLastOutputLine(null);
                }
                catch (Exception e) {
                    log.warn(e.getMessage());
                }
            }
            String result = null;
            try {
                boolean lastNull = false;
                while (!this.exited) {
                    String line = (String)this.logQueue.poll();
                    if (line == null) {
                        lastNull = true;
                        try {
                            Thread.sleep(this.waitTimeoutMillis);
                        }
                        catch (InterruptedException e) {
                            log.warn("Result worker is interrupted");
                            this.exited = true;
                        }
                        continue;
                    }
                    lastNull = false;
                    if (line == "BENCHMARK_LOG_END_MARK") break;
                    this.session.getBasicRemote().sendText(line);
                }
                this.session.getBasicRemote().sendText("log result is empty\n");
                this.session.close();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
                if (result == null) break block9;
                this.commandLineOutput.setLastOutputLine(result);
            }
        }
    }

    protected abstract String processLine(String var1);
}

