/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.model.BenchmarkStatus;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.QpsLineProcessor;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.service.IBenchmark;
import com.polarx.benchmarkboot.service.worker.ProcessCallback;
import com.polarx.benchmarkboot.util.JdbcUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Queue;
import java.util.Scanner;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BenchmarkAccessor
implements IBenchmark {
    private static final Logger log = LoggerFactory.getLogger(BenchmarkAccessor.class);
    protected final File configFile;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    protected Process process = null;
    protected String workDir = null;
    protected File logFile = null;
    protected PathConfigConstant pathConfigConstant = null;
    protected volatile BenchmarkStatus status = BenchmarkStatus.IDLE;

    public void setIdle() {
        this.status = BenchmarkStatus.IDLE;
    }

    public BenchmarkStatus getStatus() {
        if (this.process == null || !this.process.isAlive()) {
            this.status = BenchmarkStatus.IDLE;
        }
        return this.status;
    }

    protected BenchmarkAccessor(PathConfigConstant pathConfigConstant, String configFilepath) {
        this.pathConfigConstant = pathConfigConstant;
        this.configFile = new File(configFilepath);
    }

    public void update(BenchmarkDbInfo dbInfo) throws Exception {
        this.lock.writeLock().lock();
        try {
            this.beforeUpdate();
            this.updateFileInner(dbInfo);
            this.afterUpdate();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void beforeRunCheck() {
        if (this.process != null && this.process.isAlive()) {
            throw new IllegalStateException(this.getBenchmarkName() + " process is still running, please stop before rerun");
        }
    }

    public void run(BaseRunProperty runProperty, RunningContext context) {
        this.lock.writeLock().lock();
        try {
            this.status = BenchmarkStatus.RUNNING;
            runProperty.runValidate();
            this.runBenchmark(runProperty, context);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void prepare(BaseRunProperty property, RunningContext context) {
        this.lock.writeLock().lock();
        try {
            log.info("Start to load data to {}, config: {}", (Object)this.getBenchmarkDbName(), (Object)property);
            property.prepareValidate();
            this.status = BenchmarkStatus.PREPARING;
            this.prepareBenchmark(property, context);
        }
        catch (Exception e) {
            this.prepareTaskFailed(context);
            throw new RuntimeException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public abstract void saveRunInfo(ILoggedBenchmarkRunInfo var1);

    protected abstract void prepareBenchmark(BaseRunProperty var1, RunningContext var2) throws IOException, InterruptedException;

    public void stop() {
        try {
            if (this.process != null && this.process.isAlive()) {
                this.process.destroy();
                this.process = null;
            }
        }
        catch (Exception e) {
            log.warn("Failed to stop {} process: {}", (Object)this.getBenchmarkName(), (Object)e.getMessage());
        }
    }

    protected void startProcessWithShell(String command) throws IOException {
        this.startProcess(new String[]{"bash", "-c", command});
    }

    protected void startProcess(String ... commands) throws IOException {
        this.checkProcessWorking();
        log.debug(Arrays.toString(commands));
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(commands);
        builder.directory(new File(this.workDir));
        this.process = builder.start();
    }

    protected void startLoadDataProcess(RunningContext context, String ... commands) throws IOException {
        this.startProcess(commands);
        long startTime = System.currentTimeMillis();
        this.redirectProcessOutput(context.getLogQueue(), true, (ProcessCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void redirectProcessOutput(Queue<String> logQueue, boolean withEndMark) {
        this.redirectProcessOutput(logQueue, withEndMark, ProcessCallback.EMPTY);
    }

    private void redirectProcessOutput(Queue<String> logQueue, boolean withEndMark, @NotNull ProcessCallback callback) {
        logQueue.clear();
        Thread t = new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    logQueue.offer(line);
                }
                if (withEndMark) {
                    logQueue.offer("Task has finished, exiting...");
                    logQueue.offer("BENCHMARK_LOG_END_MARK");
                    callback.onFinished();
                    Thread.sleep(5000L);
                }
            }
            catch (IOException | InterruptedException e) {
                callback.onFailed();
                throw new RuntimeException(e);
            }
            finally {
                if (withEndMark) {
                    logQueue.offer("BENCHMARK_LOG_END_MARK");
                    this.status = BenchmarkStatus.IDLE;
                }
            }
        }, this.getRunnerThreadName());
        t.start();
    }

    protected void startLoadDataProcessWithShell(RunningContext context, String command) throws IOException {
        this.startLoadDataProcess(context, new String[]{"bash", "-c", command});
    }

    private static void inheritIO(InputStream src, PrintStream dest) {
        new Thread(() -> {
            Scanner sc = new Scanner(src);
            while (sc.hasNextLine()) {
                dest.println(sc.nextLine());
            }
        }).start();
    }

    protected void initLogFile() {
        String filename = this.getLogFilename();
        this.logFile = new File(this.pathConfigConstant.DATA_DIR + filename);
    }

    private String getLogFilename() {
        String curTime = new SimpleDateFormat("yyyyMMdd-HH-mm-ss").format(new Date());
        return this.getBenchmarkName() + "_" + curTime + ".log";
    }

    protected void saveOutputToFile(RunningContext context) {
        if (this.process == null) {
            throw new IllegalStateException("Process is not running");
        }
        context.clearCircularBuffer();
        Queue logQueue = context.getLogQueue();
        QpsLineProcessor qpsLineProcessor = context.newRealtimeQpsProcessor();
        new Thread(() -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    logQueue.offer(line);
                    log.error("{} error: {}", (Object)this.getBenchmarkName(), (Object)line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).start();
        Thread t = new Thread(() -> {
            Exception lastException = null;
            if (this.logFile == null) {
                return;
            }
            try (FileWriter fileWriter = new FileWriter(this.logFile);){
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                String line = null;
                int lineCount = 0;
                while ((line = reader.readLine()) != null) {
                    logQueue.offer(line);
                    this.offerQpsResult(context.getRealtimeQpsQueue(), line, qpsLineProcessor);
                    fileWriter.write(this.processLine(line, context) + "\n");
                    if (++lineCount % 10 != 0) continue;
                    fileWriter.flush();
                }
                log.info("log file {} is written", (Object)this.logFile);
                logQueue.offer("BENCHMARK_LOG_END_MARK");
                Thread.sleep(5000L);
            }
            catch (IOException | InterruptedException e) {
                lastException = e;
                throw new RuntimeException(e);
            }
            finally {
                logQueue.offer("BENCHMARK_LOG_END_MARK");
                this.status = BenchmarkStatus.IDLE;
                if (lastException != null) {
                    this.taskFailed(context);
                } else {
                    try {
                        int status = this.process.waitFor();
                        if (status == 0) {
                            log.info("Task-{} completed", (Object)context.getTaskId());
                            this.taskCompleted(context);
                        } else {
                            log.warn("Task-{} failed returning non-zero", (Object)context.getTaskId());
                            this.taskFailed(context);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }, this.getRunnerThreadName());
        t.start();
    }

    protected abstract void offerQpsResult(Queue<QpsDataRecord> var1, String var2, QpsLineProcessor var3);

    public void afterPrepare() {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        try {
            JdbcUtil.setVarAfterLoadData((BenchmarkDbInfo)benchmarkDbInfo, (CreateDbMode)this.getDbMode(benchmarkDbInfo));
        }
        catch (SQLException e) {
            log.warn(e.getMessage());
        }
    }

    public abstract CreateDbMode getDbMode(BenchmarkDbInfo var1);

    protected void prepareTaskFailed(RunningContext context) {
        this.prepareTaskFailed(context.getRunInfo());
    }

    protected void prepareTaskFailed(@NotNull ILoggedBenchmarkRunInfo runInfo) {
        this.taskFailed(runInfo);
        this.afterPrepare();
    }

    public void taskFailed(RunningContext context) {
        this.taskFailed(context.getRunInfo());
    }

    protected void taskFailed(@NotNull ILoggedBenchmarkRunInfo runInfo) {
        this.status = BenchmarkStatus.IDLE;
        if (runInfo != null) {
            runInfo.setStatus(RunningStatus.FAILED);
            this.saveRunInfo(runInfo);
        }
    }

    protected void taskCompleted(RunningContext context) {
        this.status = BenchmarkStatus.IDLE;
        context.getRunInfo().setStatus(RunningStatus.COMPLETED);
        this.saveRunInfo(context.getRunInfo());
    }

    protected abstract String processLine(String var1, RunningContext var2);

    protected void newProcess(String command) throws IOException, InterruptedException {
        this.newProcess(this.workDir, command);
    }

    protected void newProcess(String workDir, String command) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("sh", "-c", command);
        builder.directory(new File(workDir));
        Process process1 = builder.start();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process1.getInputStream()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                log.info(line);
            }
        }
        int exitCode = process1.waitFor();
        if (exitCode != 0) {
            StringBuilder errors = new StringBuilder();
            Scanner sc = new Scanner(process1.getErrorStream());
            String lastLine = null;
            while (sc.hasNextLine()) {
                lastLine = sc.nextLine();
                errors.append(lastLine).append("\n");
            }
            log.error(errors.toString());
            if (lastLine != null) {
                throw new RuntimeException(lastLine);
            }
            throw new RuntimeException("failed to execute: " + command);
        }
    }

    protected void waitForProcessSuccess(String command) throws IOException, InterruptedException {
        this.waitForProcessSuccess(this.workDir, command);
    }

    protected void waitForProcessSuccess(String workDir, String command) throws IOException, InterruptedException {
        this.waitForProcessSuccess(workDir, command, null);
    }

    protected void waitForProcessSuccess(String workDir, String command, Queue<String> logQueue) throws IOException, InterruptedException {
        this.waitForProcessSuccess(workDir, command, logQueue, true);
    }

    protected void waitForProcessSuccess(String workDir, String command, Queue<String> logQueue, boolean withEndMark) throws IOException, InterruptedException {
        int exitCode;
        this.checkProcessWorking();
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command("sh", "-c", command);
        builder.directory(new File(workDir));
        log.info("Executing: {}", (Object)command);
        this.process = builder.start();
        if (logQueue != null) {
            this.redirectProcessOutput(logQueue, withEndMark);
        }
        if ((exitCode = this.process.waitFor()) != 0) {
            StringBuilder errors = new StringBuilder();
            Scanner sc = new Scanner(this.process.getErrorStream());
            while (sc.hasNextLine()) {
                errors.append(sc.nextLine()).append("\n");
            }
            log.error(errors.toString());
            throw new RuntimeException("failed to execute " + command);
        }
    }

    protected void checkProcessWorking() {
        if (this.workDir == null) {
            throw new IllegalStateException(this.getBenchmarkName() + " working directory is not set yet");
        }
        if (this.process != null && this.process.isAlive()) {
            throw new IllegalStateException(this.getBenchmarkName() + " is still running");
        }
    }

    protected abstract void runBenchmark(BaseRunProperty var1, RunningContext var2) throws IOException, InterruptedException;

    protected abstract void updateFileInner(BenchmarkDbInfo var1) throws Exception;

    protected void beforeUpdate() {
    }

    protected void afterUpdate() {
    }

    protected abstract String getBenchmarkName();

    protected String getRunnerThreadName() {
        return this.getBenchmarkName() + "-RUNNER";
    }
}

