/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

class ParallelResultCollector {
    static final Float QPS_END_MARK = Float.valueOf(Float.NaN);
    static final int TIMEOUT_SEC = 5;
    static final int MAX_POLL_RETRY = 3;
    final List<BlockingQueue<Float>> qpsQueueList;
    final List<AtomicBoolean> finishedList;
    final List<AtomicInteger> retryCountList;

    ParallelResultCollector(int count) {
        this.qpsQueueList = new ArrayList(count);
        this.finishedList = new ArrayList(count);
        this.retryCountList = new ArrayList(count);
        for (int i = 0; i < count; ++i) {
            this.qpsQueueList.add(new LinkedTransferQueue());
            this.finishedList.add(new AtomicBoolean(false));
            this.retryCountList.add(new AtomicInteger(0));
        }
    }

    boolean enqueue(int queueIdx, Float f) {
        if (f == null) {
            return false;
        }
        return ((BlockingQueue)this.qpsQueueList.get(queueIdx)).offer(f);
    }

    Float poll() {
        boolean allFinished = this.finishedList.stream().allMatch(AtomicBoolean::get);
        if (allFinished) {
            return QPS_END_MARK;
        }
        float sum = 0.0f;
        for (int i = 0; i < this.qpsQueueList.size(); ++i) {
            AtomicBoolean finished = (AtomicBoolean)this.finishedList.get(i);
            if (finished.get()) continue;
            BlockingQueue qpsQueue = (BlockingQueue)this.qpsQueueList.get(i);
            try {
                Float qps = (Float)qpsQueue.poll(5L, TimeUnit.SECONDS);
                if (qps == null) {
                    if (((AtomicInteger)this.retryCountList.get(i)).getAndIncrement() != 3) continue;
                    finished.set(true);
                    continue;
                }
                if (Objects.equals(qps, QPS_END_MARK)) {
                    finished.set(true);
                    continue;
                }
                sum += qps.floatValue();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return Float.valueOf(sum);
    }
}

