/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.SysbenchRunInfo;
import com.polarx.benchmarkboot.model.LoadBalanceAddr;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.benchmark.QpsLineProcessor;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.SysbenchContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.SysbenchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.SysbenchProperty;
import com.polarx.benchmarkboot.repo.SysbenchRunRepository;
import com.polarx.benchmarkboot.service.ISysbenchBenchmark;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Queue;
import java.util.Scanner;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SysbenchAccessor
extends BenchmarkAccessor
implements ISysbenchBenchmark {
    private static final Logger log = LoggerFactory.getLogger(SysbenchAccessor.class);
    @Resource
    private SysbenchRunRepository sysbenchRunRepository;

    @Autowired
    public SysbenchAccessor(PathConfigConstant pathConfigConstant) {
        super(pathConfigConstant, pathConfigConstant.SYSBENCH_CONF);
        this.workDir = pathConfigConstant.SYSBENCH_HOME;
    }

    protected void runBenchmark(BaseRunProperty runProperty, RunningContext context) throws IOException, InterruptedException {
        if (this.process != null && this.process.isAlive()) {
            throw new IllegalStateException("Sysbench is still running");
        }
        this.initLogFile();
        SysbenchProperty sysbenchProp = (SysbenchProperty)runProperty;
        this.runSysbench(sysbenchProp, (SysbenchContext)context);
    }

    private void runSysbench(SysbenchProperty sysbenchProp, SysbenchContext sysbenchContext) throws IOException, InterruptedException {
        String command = sysbenchProp.getBuiltCommand();
        log.info(command);
        SysbenchRunInfo runInfo = sysbenchContext.getRunInfo();
        runInfo.setLogFilePath(this.logFile.getAbsolutePath());
        runInfo.setCommand(command);
        runInfo.setTime(Integer.valueOf(sysbenchProp.getTime()));
        runInfo.setStatus(RunningStatus.RUNNING);
        this.saveRunInfo((ILoggedBenchmarkRunInfo)runInfo);
        this.startProcessWithShell(command);
        this.saveOutputToFile((RunningContext)sysbenchContext);
        Thread.sleep(500L);
        if (!this.process.isAlive()) {
            throw new IllegalStateException("Run sysbench failed, please check the log");
        }
    }

    public void saveRunInfo(ILoggedBenchmarkRunInfo runInfo) {
        this.sysbenchRunRepository.save((Object)((SysbenchRunInfo)runInfo));
    }

    protected void prepareBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        SysbenchPrepareProperty prepareProperty = (SysbenchPrepareProperty)property;
        String command = prepareProperty.getBuiltCommand();
        log.info(command);
        ILoggedBenchmarkRunInfo runInfo = context.getRunInfo();
        runInfo.setStatus(RunningStatus.RUNNING);
        this.saveRunInfo(runInfo);
        this.startLoadDataProcessWithShell(context, command);
        Thread.sleep(500L);
        if (!this.process.isAlive() && this.process.exitValue() != 0) {
            if (this.process.exitValue() != 0) {
                StringBuilder errors = new StringBuilder();
                Scanner sc = new Scanner(this.process.getErrorStream());
                while (sc.hasNextLine()) {
                    errors.append(sc.nextLine()).append("\n");
                }
                log.error(errors.toString());
            }
            throw new IllegalStateException("Prepare sysbench failed, please check the log");
        }
    }

    protected void offerQpsResult(Queue<QpsDataRecord> realtimeQpsQueue, String line, QpsLineProcessor qpsProcessor) {
        QpsDataRecord qps = this.parseQps(qpsProcessor, line);
        if (qps != null) {
            realtimeQpsQueue.offer(qps);
        }
    }

    private QpsDataRecord parseQps(QpsLineProcessor qpsProcessor, String line) {
        if (StringUtils.isBlank((String)line)) {
            return null;
        }
        return qpsProcessor.processLine(line);
    }

    public CreateDbMode getDbMode(BenchmarkDbInfo benchmarkDbInfo) {
        return benchmarkDbInfo.getSysbenchMode();
    }

    protected String processLine(String line, RunningContext context) {
        int idx;
        int len = line.length();
        if (len <= "avg:".length() || !Character.isSpaceChar(line.charAt(0))) {
            return line;
        }
        for (idx = 0; idx < len && Character.isSpaceChar(line.charAt(idx)); ++idx) {
        }
        if (idx >= len - 3) {
            return line;
        }
        if (line.charAt(idx) != 'a' && line.charAt(len - 1) != ')') {
            return line;
        }
        StringBuilder stringBuilder = new StringBuilder(10);
        SysbenchRunInfo runInfo = ((SysbenchContext)context).getRunInfo();
        char ch1 = line.charAt(idx);
        char ch2 = line.charAt(idx + 1);
        char ch3 = line.charAt(idx + 2);
        if (idx < len - "transactions:".length() && ch1 == 't' && ch2 == 'r' && ch3 == 'a') {
            while (idx < len && line.charAt(idx) != '(') {
                ++idx;
            }
            if (idx == len) {
                return line;
            }
            ++idx;
            while (idx < len && line.charAt(idx) != ' ') {
                stringBuilder.append(line.charAt(idx));
                ++idx;
            }
            String tps = stringBuilder.toString();
            runInfo.setTps(tps);
            this.saveRunInfo((ILoggedBenchmarkRunInfo)runInfo);
            log.debug("Saving sysbench tps {}", (Object)tps);
            return line;
        }
        if (idx < len - "queries:".length() && ch1 == 'q' && ch2 == 'u' && ch3 == 'e') {
            while (idx < len && line.charAt(idx) != '(') {
                ++idx;
            }
            if (idx == len) {
                return line;
            }
            ++idx;
            while (idx < len && line.charAt(idx) != ' ') {
                stringBuilder.append(line.charAt(idx));
                ++idx;
            }
            String qps = stringBuilder.toString();
            runInfo.setQps(qps);
            this.saveRunInfo((ILoggedBenchmarkRunInfo)runInfo);
            log.debug("Saving sysbench qps: {}", (Object)qps);
            return line;
        }
        if (idx < len - "avg:".length() && ch1 == 'a' && ch2 == 'v' && ch3 == 'g') {
            idx += 4;
            while (idx < len && Character.isSpaceChar(line.charAt(idx))) {
                ++idx;
            }
            while (idx < len) {
                stringBuilder.append(line.charAt(idx++));
            }
            String lat = stringBuilder.toString();
            runInfo.setLatency(lat);
            this.saveRunInfo((ILoggedBenchmarkRunInfo)runInfo);
            log.debug("Saving sysbench avg latency: {}", (Object)lat);
            return line;
        }
        return line;
    }

    protected void updateFileInner(BenchmarkDbInfo dbInfo) throws Exception {
        String port;
        String host;
        if (StringUtils.isBlank((String)dbInfo.getSysbenchDbName())) {
            log.info("Skip updating {} config file", (Object)this.getBenchmarkName());
            return;
        }
        if (dbInfo.isLoadBalance()) {
            LoadBalanceAddr loadBalanceAddr = LoadBalanceAddr.parse((String)dbInfo.getLoadBalanceAddr());
            host = loadBalanceAddr.getFormattedHost();
            port = loadBalanceAddr.getFormattedPort();
        } else {
            host = dbInfo.getHost();
            port = Integer.toString(dbInfo.getPort());
        }
        this.writeSingleConfigFile(this.configFile, host, port, dbInfo);
    }

    private void writeSingleConfigFile(File file, String host, String port, BenchmarkDbInfo dbInfo) throws IOException {
        try (FileWriter fw = new FileWriter(file);){
            fw.write(String.format("mysql-host='%s'%n", host));
            fw.write(String.format("mysql-port='%s'%n", port));
            fw.write(String.format("mysql-user='%s'%n", dbInfo.getUser()));
            fw.write(String.format("mysql-password='%s'%n", dbInfo.fetchPasswordPlainText()));
            fw.write(String.format("mysql-db='%s'%n", dbInfo.getSysbenchDbName()));
            fw.write(String.format("db-driver='mysql'%n", new Object[0]));
            fw.write(String.format("percentile='95'%n", new Object[0]));
            fw.write(String.format("report-interval='1'%n", new Object[0]));
            fw.write(String.format("time='60'%n", new Object[0]));
            fw.write(String.format("rand-type='uniform'%n", new Object[0]));
            log.info("{} is written", (Object)file.getAbsolutePath());
        }
    }

    protected String getBenchmarkName() {
        return "Sysbench";
    }
}

