/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.model.benchmark.StreamingCommandLineOutput;
import com.polarx.benchmarkboot.model.benchmark.SysbenchContext;
import com.polarx.benchmarkboot.service.worker.BaseResultWorker;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysbenchResultWorker
extends BaseResultWorker {
    private static final Logger log = LoggerFactory.getLogger(SysbenchResultWorker.class);
    private final StringBuilder stringBuilder = new StringBuilder(10);

    public SysbenchResultWorker(SysbenchContext context, Session session) {
        super((StreamingCommandLineOutput)context, session);
        this.waitTimeoutMillis = 2000;
    }

    protected String processLine(String line) {
        int idx;
        if (line.isEmpty() || line.charAt(0) != '[') {
            return null;
        }
        this.stringBuilder.setLength(0);
        int writtenFields = 0;
        boolean EXPECTED_COUNT = true;
        int len = line.length();
        for (idx = 2; idx < len && (idx >= len - 5 || line.charAt(idx) != 'q' || line.charAt(idx + 1) != 'p' || line.charAt(idx + 2) != 's'); ++idx) {
        }
        idx += "qps: ".length();
        while (idx < len) {
            if (line.charAt(idx) == ' ') {
                ++writtenFields;
                break;
            }
            this.stringBuilder.append(line.charAt(idx));
            ++idx;
        }
        if (writtenFields != 1) {
            throw new IllegalStateException("Failed to parse sysbench output");
        }
        return this.stringBuilder.toString();
    }
}

