/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.TpccRunInfo;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.QpsLineProcessor;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TpccContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.TpccPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TpccProperty;
import com.polarx.benchmarkboot.model.dto.rsp.MultiLineMessageBuilder;
import com.polarx.benchmarkboot.repo.TpccRunRepository;
import com.polarx.benchmarkboot.service.ITpccBenchmark;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.service.worker.TpccAccessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.Scanner;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class TpccAccessor
extends BenchmarkAccessor
implements ITpccBenchmark {
    private static final Logger log = LoggerFactory.getLogger(TpccAccessor.class);
    @Resource
    private TpccRunRepository tpccRunRepository;
    private final File tpccOriginConf;
    private final boolean[] modifiedOptions = new boolean[]{false, false, false};
    private static final String MATCH_TPMC_STR = "(NewOrders) = ";

    @Autowired
    public TpccAccessor(PathConfigConstant pathConfigConstant) {
        super(pathConfigConstant, pathConfigConstant.TPCC_CONF);
        this.tpccOriginConf = new File(pathConfigConstant.TPCC_ORIGIN_CONF);
        if (!this.tpccOriginConf.exists() || !this.tpccOriginConf.isFile()) {
            throw new IllegalArgumentException("Cannot access " + this.tpccOriginConf);
        }
        this.workDir = pathConfigConstant.TPCC_HOME;
    }

    public void saveRunInfo(ILoggedBenchmarkRunInfo runInfo) {
        this.tpccRunRepository.save((Object)((TpccRunInfo)runInfo));
    }

    protected void prepareBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        CreateDbMode tpccMode = BenchmarkContext.getInstance().getBenchmarkDbInfo().getTpccMode();
        String dbMode = tpccMode.name();
        TpccPrepareProperty tpccProperty = (TpccPrepareProperty)property;
        Object command = String.format("bash configure_load.sh %s %d %d %s %d", this.configFile.getAbsolutePath(), tpccProperty.getWarehouses(), tpccProperty.getThreads(), dbMode, tpccProperty.getPartitions());
        if (tpccProperty.getStartWarehouse() != null) {
            command = (String)command + " " + tpccProperty.getStartWarehouse();
            if (tpccProperty.getEndWarehouse() != null) {
                command = (String)command + " " + tpccProperty.getEndWarehouse();
            }
        }
        this.waitForProcessSuccess((String)command);
        ILoggedBenchmarkRunInfo runInfo = context.getRunInfo();
        runInfo.setStatus(RunningStatus.RUNNING);
        this.saveRunInfo(runInfo);
        this.startLoadDataProcess(context, new String[]{"bash", "./runDatabaseBuild.sh", this.configFile.getAbsolutePath()});
        Thread.sleep(500L);
        if (!this.process.isAlive() && this.process.exitValue() != 0) {
            if (this.process.exitValue() != 0) {
                StringBuilder errors = new StringBuilder();
                Scanner sc = new Scanner(this.process.getErrorStream());
                while (sc.hasNextLine()) {
                    errors.append(sc.nextLine()).append("\n");
                }
                log.error(errors.toString());
            }
            throw new IllegalStateException("Prepare TPC-C failed, please check the log");
        }
    }

    protected String processLine(String line, RunningContext context) {
        int len = line.length();
        if (len < 50 || line.charAt(0) == '[' || line.charAt(14) == 'm') {
            return line;
        }
        int idx = line.indexOf("(NewOrders) = ", 50);
        if (idx == -1) {
            return line;
        }
        String tpmC = line.substring(idx += "(NewOrders) = ".length());
        TpccRunInfo runInfo = ((TpccContext)context).getRunInfo();
        runInfo.setTpmC(tpmC);
        this.tpccRunRepository.save((Object)runInfo);
        log.debug("Saving TPC-C tpmC NewOrders: {}", (Object)tpmC);
        return line;
    }

    protected void runBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        Object command;
        if (this.process != null && this.process.isAlive()) {
            throw new IllegalStateException("TPC-C is still running");
        }
        this.initLogFile();
        TpccContext tpccContext = (TpccContext)context;
        TpccRunInfo runInfo = tpccContext.getRunInfo();
        TpccProperty tpccProperty = (TpccProperty)property;
        if (tpccProperty.isUseStoredProcedure()) {
            try {
                command = "bash runProcedureBuild.sh " + this.configFile.getAbsolutePath();
                this.waitForProcessSuccess((String)command);
                log.info("Create procedures successfully");
            }
            catch (RuntimeException e) {
                log.error(e.getMessage());
                throw new RuntimeException("Failed to create procedures");
            }
        }
        command = String.format("bash configure_run.sh %s %d %d %d %d %d %d %d", this.configFile.getAbsolutePath(), tpccProperty.getWarehouses(), tpccProperty.getThreads(), tpccProperty.getTimeMins(), tpccProperty.getNewOrderRemotePercent(), tpccProperty.getPaymentRemotePercent(), tpccProperty.isSaveTrxRt() ? runInfo.getId() : -1, tpccProperty.isUseStoredProcedure() ? 1 : 0);
        this.waitForProcessSuccess((String)command);
        runInfo.setStatus(RunningStatus.RUNNING);
        runInfo.setLogFilePath(this.logFile.getAbsolutePath());
        this.tpccRunRepository.save((Object)runInfo);
        this.startProcess(new String[]{"bash", "./runBenchmark.sh", this.configFile.getAbsolutePath()});
        this.saveOutputToFile(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFileInner(BenchmarkDbInfo dbInfo) throws Exception {
        if (StringUtils.isBlank((String)dbInfo.getTpccDbName())) {
            log.info("Skip updating {} config file", (Object)this.getBenchmarkName());
            return;
        }
        try (FileWriter fw = new FileWriter(this.configFile);
             BufferedReader originConfReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.tpccOriginConf)));){
            String line = null;
            while ((line = originConfReader.readLine()) != null) {
                if (line.startsWith(ConfOption.CONN.start)) {
                    int jdbcParamIndex = line.indexOf(63);
                    if (jdbcParamIndex == -1) {
                        fw.write(this.getJdbcUrl(dbInfo, null));
                    } else {
                        String jdbcParam = line.substring(jdbcParamIndex + 1);
                        fw.write(this.getJdbcUrl(dbInfo, jdbcParam));
                    }
                    this.modifiedOptions[ConfOption.CONN.index] = true;
                    continue;
                }
                if (line.startsWith(ConfOption.USER.start)) {
                    fw.write(String.format("user=%s%n", dbInfo.getUser()));
                    this.modifiedOptions[ConfOption.USER.index] = true;
                    continue;
                }
                if (line.startsWith(ConfOption.PASSWORD.start)) {
                    fw.write(String.format("password=%s%n", dbInfo.fetchPasswordPlainText()));
                    this.modifiedOptions[ConfOption.PASSWORD.index] = true;
                    continue;
                }
                if (line.startsWith("resultDirectory")) {
                    fw.write("//");
                }
                fw.write(String.format("%s%n", line));
            }
            for (int i = 0; i < this.modifiedOptions.length; ++i) {
                if (this.modifiedOptions[i]) continue;
                throw new IllegalArgumentException("TPCC origin config require arg: " + ConfOption.getFromIndex((int)i).name());
            }
        }
        finally {
            Arrays.fill(this.modifiedOptions, false);
            log.info("{} is written", (Object)this.configFile.getAbsolutePath());
        }
    }

    private String getJdbcUrl(BenchmarkDbInfo dbInfo, String jdbcParam) {
        if (StringUtils.isBlank((String)jdbcParam)) {
            if (dbInfo.isLoadBalance()) {
                return String.format("conn=jdbc:mysql:loadbalance://%s/%s%n", dbInfo.getLoadBalanceAddr(), dbInfo.getTpccDbName());
            }
            return String.format("conn=jdbc:mysql://%s:%d/%s%n", dbInfo.getHost(), dbInfo.getPort(), dbInfo.getTpccDbName());
        }
        if (dbInfo.isLoadBalance()) {
            return String.format("conn=jdbc:mysql:loadbalance://%s/%s?%s%n", dbInfo.getLoadBalanceAddr(), dbInfo.getTpccDbName(), jdbcParam);
        }
        return String.format("conn=jdbc:mysql://%s:%d/%s?%s%n", dbInfo.getHost(), dbInfo.getPort(), dbInfo.getTpccDbName(), jdbcParam);
    }

    public void stop() {
        String command = "bash kill_tpcc.sh";
        try {
            this.newProcess(command);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void offerQpsResult(Queue<QpsDataRecord> realtimeQpsQueue, String line, QpsLineProcessor qpsProcessor) {
        QpsDataRecord qps = this.parseQps(qpsProcessor, line);
        if (qps != null) {
            realtimeQpsQueue.offer(qps);
        }
    }

    private QpsDataRecord parseQps(QpsLineProcessor tpmcProcessor, String line) {
        if (StringUtils.isBlank((String)line)) {
            return null;
        }
        return tpmcProcessor.processLine(line);
    }

    public CreateDbMode getDbMode(BenchmarkDbInfo benchmarkDbInfo) {
        return benchmarkDbInfo.getTpccMode();
    }

    protected String getBenchmarkName() {
        return "TPC-C";
    }

    public void processTrxRt(File myResultDir, MultiLineMessageBuilder result) {
        String command = String.format("bash process_rt.sh %s", myResultDir.getAbsolutePath());
        ArrayDeque msgQueue = new ArrayDeque(16);
        try {
            this.waitForProcessSuccess(this.workDir, command, msgQueue, false);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        while (!msgQueue.isEmpty()) {
            result.appendLine((String)msgQueue.poll());
        }
    }
}

