/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.model.benchmark.StreamingCommandLineOutput;
import com.polarx.benchmarkboot.model.benchmark.TpccContext;
import com.polarx.benchmarkboot.service.worker.BaseResultWorker;
import javax.websocket.Session;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TpccResultWorker
extends BaseResultWorker {
    private static final Logger log = LoggerFactory.getLogger(TpccResultWorker.class);
    private final StringBuilder stringBuilder = new StringBuilder(10);

    public TpccResultWorker(TpccContext context, Session session) {
        super((StreamingCommandLineOutput)context, session);
        this.waitTimeoutMillis = 5000;
    }

    protected String processLine(String line) {
        if (line.isEmpty() || line.charAt(0) != '[') {
            return null;
        }
        String[] parts = StringUtils.split((String)line, (String)":");
        if (parts.length != 6) {
            throw new IllegalStateException("Failed to parse TPC-C output");
        }
        String[] subParts = StringUtils.split((String)parts[4], (char)'\t');
        if (subParts.length != 2) {
            throw new IllegalStateException("Failed to parse TPC-C output");
        }
        return StringUtils.stripStart((String)subParts[0], null);
    }
}

