/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.alibaba.fastjson.JSON;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.entity.TpchRunInfo;
import com.polarx.benchmarkboot.exception.QueryFailedException;
import com.polarx.benchmarkboot.model.BenchmarkStatus;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.RunningStatus;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.QpsLineProcessor;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.benchmark.TpchContext;
import com.polarx.benchmarkboot.model.benchmark.TpchQuery;
import com.polarx.benchmarkboot.model.benchmark.TpchSingleQueryResult;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.TpchPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TpchProperty;
import com.polarx.benchmarkboot.model.bo.TpchQueryHintMap;
import com.polarx.benchmarkboot.repo.TpchRunRepository;
import com.polarx.benchmarkboot.service.ITpchBenchmark;
import com.polarx.benchmarkboot.service.MonitorService;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.service.worker.TpchAccessor;
import com.polarx.benchmarkboot.util.FileUtil;
import com.polarx.benchmarkboot.util.JdbcUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TpchAccessor
extends BenchmarkAccessor
implements ITpchBenchmark {
    private static final Logger log = LoggerFactory.getLogger(TpchAccessor.class);
    private static final boolean NEED_GENERATE_DATA = false;
    @Resource
    private TpchRunRepository tpchRunRepository;
    @Resource
    private MonitorService monitorService;
    @Resource
    private TpchQuery tpchQuery;
    private FutureTask<Long> loadTpchTask = null;
    private volatile boolean stopped = false;
    private volatile Long connectionId = null;

    @Autowired
    public TpchAccessor(PathConfigConstant pathConfigConstant) {
        super(pathConfigConstant, pathConfigConstant.TPCH_CONF);
        this.workDir = pathConfigConstant.TPCH_HOME;
    }

    protected void prepareBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        TpchPrepareProperty tpchProperty = (TpchPrepareProperty)property;
        if (!tpchProperty.isSkipCreateTable()) {
            this.createTpchTables(tpchProperty);
        }
        this.configureLoad(tpchProperty.getParallelism());
        ILoggedBenchmarkRunInfo runInfo = context.getRunInfo();
        runInfo.setStatus(RunningStatus.RUNNING);
        this.saveRunInfo(runInfo);
        this.stopped = false;
        this.loadDataAsync(tpchProperty.getGb(), context.getLogQueue(), runInfo);
    }

    private void checkDiskSpace(int gb) {
        double freeSpace = this.monitorService.getFreeDiskSpaceInGb();
        if (freeSpace < (double)(gb + 5)) {
            throw new RuntimeException("Disk free space not enough for " + gb + " GB");
        }
    }

    private void configureLoad(int parallelism) throws IOException, InterruptedException {
        if (parallelism < 0) {
            return;
        }
        String command = String.format("bash configure_load.sh %d", parallelism);
        this.waitForProcessSuccess(this.pathConfigConstant.TPCH_HOME + "/tpch-data/", command);
    }

    /*
     * Exception decompiling
     */
    private void createTpchTables(TpchPrepareProperty tpchProperty) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int getDnCount(Connection conn) {
        try (Statement stmt = conn.createStatement();){
            int n;
            block16: {
                ResultSet rs = stmt.executeQuery("show storage");
                try {
                    int dnCount = 0;
                    while (rs.next()) {
                        ++dnCount;
                    }
                    if (dnCount <= 1) {
                        throw new IllegalStateException("Illegal DN count: " + dnCount);
                    }
                    n = --dnCount;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadDataAsync(int gb, Queue<String> logQueue, ILoggedBenchmarkRunInfo runInfo) {
        Thread t = new Thread((Runnable)new LoadDataRunner(this, gb, logQueue, runInfo), "tpch-loader");
        t.start();
    }

    protected String processLine(String line, RunningContext context) {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected void runBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        TpchProperty tpchProperty = (TpchProperty)property;
        TpchContext tpchContext = (TpchContext)context;
        TpchQueryHintMap queryHintMap = tpchProperty.getQueryHintMap();
        this.stopped = false;
        new Thread(() -> {
            try {
                this.runQueries(queryHintMap, tpchContext, tpchProperty.isAllQueries());
                this.taskCompleted((RunningContext)tpchContext);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                this.taskFailed(context);
            }
            finally {
                tpchContext.getLogQueue().offer("BENCHMARK_LOG_END_MARK");
                this.status = BenchmarkStatus.IDLE;
            }
        }, this.getRunnerThreadName()).start();
    }

    private void runQueries(TpchQueryHintMap queryHintMap, TpchContext tpchContext, boolean allQueries) {
        TpchRunInfo runInfo = tpchContext.getRunInfo();
        runInfo.setStatus(RunningStatus.RUNNING);
        this.saveRunInfo((ILoggedBenchmarkRunInfo)runInfo);
        ArrayList<TpchSingleQueryResult> resultList = new ArrayList<TpchSingleQueryResult>();
        Queue logQueue = tpchContext.getLogQueue();
        double total = 0.0;
        for (int queryId = 1; queryId <= 22; ++queryId) {
            if (this.stopped) {
                throw new QueryFailedException("TPC-H task is stopped");
            }
            if (!allQueries && !queryHintMap.containsId(queryId)) continue;
            String queryHint = queryHintMap.getHint(queryId);
            String msg = String.format("Start to run query-%d with hint: %s", queryId, queryHint);
            this.appendRunningMessage(logQueue, msg);
            double runSeconds = this.runQuery(queryId, queryHint);
            msg = String.format("Query-%d cost %f seconds", queryId, runSeconds);
            this.appendRunningMessage(logQueue, msg);
            resultList.add(new TpchSingleQueryResult(queryId, String.format("%.2f", runSeconds)));
            this.updateQueryResult(runInfo, resultList, total += runSeconds);
        }
    }

    private void appendRunningMessage(Queue<String> logQueue, String msg) {
        log.info(msg);
        logQueue.offer(msg);
    }

    /*
     * Exception decompiling
     */
    private double runQuery(int queryId, String queryHint) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateQueryResult(TpchRunInfo runInfo, List<TpchSingleQueryResult> resultList, double total) {
        String resultJson = JSON.toJSONString(resultList);
        runInfo.setResult(resultJson);
        runInfo.setTotal(String.format("%.2f", total));
        runInfo.setStatus(RunningStatus.RUNNING);
        this.saveRunInfo((ILoggedBenchmarkRunInfo)runInfo);
    }

    private Connection getTpchConnection() throws SQLException {
        BenchmarkDbInfo benchmarkDbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
        return JdbcUtil.getDbConnection((BenchmarkDbInfo)benchmarkDbInfo, (String)benchmarkDbInfo.getTpchDbName());
    }

    public BenchmarkStatus getStatus() {
        return this.status;
    }

    public void saveRunInfo(ILoggedBenchmarkRunInfo runInfo) {
        this.tpchRunRepository.save((Object)((TpchRunInfo)runInfo));
    }

    protected void updateFileInner(BenchmarkDbInfo dbInfo) throws Exception {
        if (StringUtils.isBlank((String)dbInfo.getTpchDbName())) {
            log.info("Skip updating {} config file", (Object)this.getBenchmarkName());
            return;
        }
        try (FileWriter fw = new FileWriter(this.configFile);){
            fw.write(String.format("host=%s%n", dbInfo.getHost()));
            fw.write(String.format("port=%s%n", dbInfo.getPort()));
            fw.write(String.format("user=%s%n", dbInfo.getUser()));
            fw.write(String.format("password=%s%n", dbInfo.fetchPasswordPlainText()));
            fw.write(String.format("db=%s%n", dbInfo.getTpchDbName()));
            if (dbInfo.isLoadBalance()) {
                fw.write(String.format("loadBalance=%s%n", dbInfo.getLoadBalanceAddr()));
            }
        }
        log.info("{} is written", (Object)this.configFile.getAbsolutePath());
    }

    public void stop() {
        this.stopped = true;
        super.stop();
        if (this.connectionId != null) {
            try (Connection conn = this.getTpchConnection();
                 Statement stmt = conn.createStatement();){
                String sql = String.format("kill query %d", this.connectionId);
                stmt.execute(sql);
                log.info("Executed: {}", (Object)sql);
            }
            catch (SQLException e) {
                log.error(e.getMessage());
            }
        }
    }

    protected void offerQpsResult(Queue<QpsDataRecord> realtimeQpsQueue, String line, QpsLineProcessor qpsProcessor) {
        throw new UnsupportedOperationException("TPC-H does not support realtime result");
    }

    public CreateDbMode getDbMode(BenchmarkDbInfo benchmarkDbInfo) {
        return benchmarkDbInfo.getTpchMode();
    }

    protected String getBenchmarkName() {
        return "TPC-H";
    }

    @Deprecated
    private boolean dataGenerated(int scaleFactor) {
        File textDataDir = new File(this.pathConfigConstant.DATA_DIR + String.format("/tpch/SF%d", scaleFactor));
        if (!textDataDir.exists() || !textDataDir.isDirectory()) {
            return false;
        }
        if ((double)FileUtil.getDirectorySize((File)textDataDir) < (double)scaleFactor * 0.95) {
            return false;
        }
        log.info("TPC-H scale[{}] existed", (Object)scaleFactor);
        return true;
    }
}

