/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.service.worker;

import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.entity.ILoggedBenchmarkRunInfo;
import com.polarx.benchmarkboot.exception.HistoryNotSupportException;
import com.polarx.benchmarkboot.model.PathConfigConstant;
import com.polarx.benchmarkboot.model.benchmark.BenchmarkContext;
import com.polarx.benchmarkboot.model.benchmark.QpsLineProcessor;
import com.polarx.benchmarkboot.model.benchmark.RunningContext;
import com.polarx.benchmarkboot.model.bo.BaseRunProperty;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import com.polarx.benchmarkboot.model.bo.QpsDataRecord;
import com.polarx.benchmarkboot.model.bo.TransferPrepareProperty;
import com.polarx.benchmarkboot.model.bo.TransferProperty;
import com.polarx.benchmarkboot.service.ITransferBenchmark;
import com.polarx.benchmarkboot.service.worker.BenchmarkAccessor;
import com.polarx.benchmarkboot.service.worker.TransferAccessor;
import com.polarx.benchmarkboot.util.FileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Queue;
import java.util.Scanner;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransferAccessor
extends BenchmarkAccessor
implements ITransferBenchmark {
    private static final Logger log = LoggerFactory.getLogger(TransferAccessor.class);
    private final File transferPrepareConf;

    @Autowired
    public TransferAccessor(PathConfigConstant pathConfigConstant) {
        super(pathConfigConstant, pathConfigConstant.TRANSFER_CONF);
        this.transferPrepareConf = new File(pathConfigConstant.TRANSFER_HOME + "/config_prepare.toml");
        this.workDir = pathConfigConstant.TRANSFER_HOME;
    }

    public void saveRunInfo(ILoggedBenchmarkRunInfo runInfo) {
        throw new HistoryNotSupportException();
    }

    protected void prepareBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        TransferPrepareProperty transferPrepareProperty = (TransferPrepareProperty)property;
        this.writePrepareConfig(transferPrepareProperty);
        this.startLoadDataProcess(context, new String[]{"bash", "-c", "transfer prepare -config=" + this.transferPrepareConf.getAbsolutePath()});
        Thread.sleep(500L);
        if (!this.process.isAlive() && this.process.exitValue() != 0) {
            if (this.process.exitValue() != 0) {
                StringBuilder errors = new StringBuilder();
                Scanner sc = new Scanner(this.process.getErrorStream());
                while (sc.hasNextLine()) {
                    errors.append(sc.nextLine()).append("\n");
                }
                log.error(errors.toString());
            }
            throw new IllegalStateException("Prepare Transfer failed, please check the log");
        }
    }

    private void writePrepareConfig(TransferPrepareProperty prepareProperty) {
        try (FileWriter fw = new FileWriter(this.transferPrepareConf);
             BufferedWriter bw = new BufferedWriter(fw);){
            BenchmarkDbInfo dbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            String datasource = String.format("%s:%s@tcp(%s:%d)/%s", dbInfo.getUser(), dbInfo.fetchPasswordPlainText(), dbInfo.getHost(), dbInfo.getPort(), this.getBenchmarkDbName());
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("dsn = '%s'", datasource));
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("row_count = %d", prepareProperty.getTableSize()));
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("initial_balance = %d", prepareProperty.getBalance()));
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("create_table_suffix = '%s'", prepareProperty.getCreateTableOptions()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String processLine(String line, RunningContext context) {
        return null;
    }

    protected void runBenchmark(BaseRunProperty property, RunningContext context) throws IOException, InterruptedException {
        if (this.process != null && this.process.isAlive()) {
            throw new IllegalStateException("Transfer is still running");
        }
        TransferProperty transferProperty = (TransferProperty)property;
        this.writeRunConfig(transferProperty);
        this.startProcess(new String[]{"bash", "-c", "transfer run -config=" + this.configFile.getAbsolutePath()});
        this.scheduleStopTask(transferProperty.getTime());
        this.saveOutputToFile(context);
    }

    private void scheduleStopTask(int seconds) {
        if (seconds <= 0) {
            return;
        }
        Timer timer = new Timer();
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        timer.schedule((TimerTask)task, TimeUnit.SECONDS.toMillis(seconds));
    }

    private void writeRunConfig(TransferProperty transferProperty) {
        try (FileWriter fw = new FileWriter(this.configFile);
             BufferedWriter bw = new BufferedWriter(fw);){
            BenchmarkDbInfo dbInfo = BenchmarkContext.getInstance().getBenchmarkDbInfo();
            String datasource = String.format("%s:%s@tcp(%s:%d)/%s", dbInfo.getUser(), dbInfo.fetchPasswordPlainText(), dbInfo.getHost(), dbInfo.getPort(), this.getBenchmarkDbName());
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("dsn = '%s'", datasource));
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("row_count = %d", transferProperty.getTableSize()));
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("initial_balance = %d", transferProperty.getBalance()));
            FileUtil.writeLine((BufferedWriter)bw, (String)"replica_strong_consistency = true");
            FileUtil.writeLine((BufferedWriter)bw, (String)"[transfer_simple]");
            this.writeEnableAndThreads(bw, transferProperty.getSimpleThreads());
            FileUtil.writeLine((BufferedWriter)bw, (String)"[check_balance]");
            this.writeEnableAndThreads(bw, transferProperty.getCheckBalanceThreads());
            FileUtil.writeLine((BufferedWriter)bw, (String)"[replica_read]");
            this.writeEnableAndThreads(bw, transferProperty.getReplicaThreads());
            FileUtil.writeLine((BufferedWriter)bw, (String)"replica_read_hint = '/*+TDDL:SLAVE()*/'");
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("replica_dsn = '%s'", datasource));
            FileUtil.writeLine((BufferedWriter)bw, (String)"session_var = ''");
            FileUtil.writeLine((BufferedWriter)bw, (String)"[replica_session_hint]");
            this.writeEnableAndThreads(bw, transferProperty.getReplicaSessionHintThreads());
            FileUtil.writeLine((BufferedWriter)bw, (String)"replica_read_hint = '/*+TDDL:SLAVE()*/'");
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("replica_dsn = '%s'", datasource));
            FileUtil.writeLine((BufferedWriter)bw, (String)"session_var = ''");
            FileUtil.writeLine((BufferedWriter)bw, (String)"[flashback_query]");
            this.writeEnableAndThreads(bw, transferProperty.getFlashbackThreads());
            FileUtil.writeLine((BufferedWriter)bw, (String)"min_seconds = 10");
            FileUtil.writeLine((BufferedWriter)bw, (String)"max_seconds = 20");
            FileUtil.writeLine((BufferedWriter)bw, (String)"[replica_flashback_query]");
            this.writeEnableAndThreads(bw, transferProperty.getReplicaFlashbackThreads());
            FileUtil.writeLine((BufferedWriter)bw, (String)"min_seconds = 10");
            FileUtil.writeLine((BufferedWriter)bw, (String)"max_seconds = 20");
            FileUtil.writeLine((BufferedWriter)bw, (String)"replica_read_hint = '/*+TDDL:SLAVE()*/'");
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("replica_dsn = '%s'", datasource));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEnableAndThreads(BufferedWriter bw, int threads) throws IOException {
        if (threads > 0) {
            FileUtil.writeLine((BufferedWriter)bw, (String)"enabled = true");
            FileUtil.writeLine((BufferedWriter)bw, (String)String.format("threads = %d", threads));
        } else {
            FileUtil.writeLine((BufferedWriter)bw, (String)"enabled = false");
            FileUtil.writeLine((BufferedWriter)bw, (String)"threads = 0");
        }
    }

    protected void updateFileInner(BenchmarkDbInfo dbInfo) throws Exception {
        log.info("No need to update {} config file", (Object)this.getBenchmarkName());
    }

    protected void offerQpsResult(Queue<QpsDataRecord> realtimeQpsQueue, String line, QpsLineProcessor qpsProcessor) {
        throw new UnsupportedOperationException();
    }

    public CreateDbMode getDbMode(BenchmarkDbInfo benchmarkDbInfo) {
        return benchmarkDbInfo.getTransferMode();
    }

    protected String getBenchmarkName() {
        return "Transfer";
    }
}

