/*
 * Decompiled with CFR 0.152.
 */
package com.polarx.benchmarkboot.util;

import com.mysql.jdbc.Driver;
import com.polarx.benchmarkboot.entity.BenchmarkDbInfo;
import com.polarx.benchmarkboot.model.bo.CreateDbMode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class JdbcUtil {
    private static final Logger log = LoggerFactory.getLogger(JdbcUtil.class);
    private static final String URL_PREFIX = "jdbc:mysql://";
    public static final String DEFAULT_DB_NAME = "information_schema";
    public static final List<String> BEFORE_LOAD_DATA_SQL_LIST = new /* Unavailable Anonymous Inner Class!! */;
    public static final List<String> AUTO_MODE_BEFORE_LOAD_DATA_SQL_LIST = new /* Unavailable Anonymous Inner Class!! */;
    public static final List<String> AFTER_LOAD_DATA_SQL_LIST = new /* Unavailable Anonymous Inner Class!! */;
    public static final List<String> AUTO_MODE_AFTER_LOAD_DATA_SQL_LIST = new /* Unavailable Anonymous Inner Class!! */;

    public static Connection getDbConnection(BenchmarkDbInfo dbInfo) throws SQLException {
        return JdbcUtil.getDbConnection((BenchmarkDbInfo)dbInfo, (String)"information_schema");
    }

    public static Connection getDbConnection(BenchmarkDbInfo dbInfo, String dbName) throws SQLException {
        String URL_PATTERN = "jdbc:mysql://%s:%s/%s?useSSL=false&useUnicode=true";
        String url = String.format("jdbc:mysql://%s:%s/%s?useSSL=false&useUnicode=true", dbInfo.getHost(), dbInfo.getPort(), dbName);
        Driver driver = new Driver();
        Properties info = new Properties();
        info.put("user", dbInfo.getUser());
        if (dbInfo.fetchPasswordPlainText() != null && !dbInfo.fetchPasswordPlainText().isBlank()) {
            info.put("password", dbInfo.fetchPasswordPlainText());
        }
        return driver.connect(url, info);
    }

    public static Statement createStreamingStatement(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.setFetchSize(Integer.MIN_VALUE);
        return stmt;
    }

    public static void createDb(Connection conn, String dbName, CreateDbMode mode) {
        try (Statement stmt = conn.createStatement();){
            String ddl = mode == CreateDbMode.MYSQL ? String.format("create database `%s`", dbName) : String.format("create database `%s` mode = %s", dbName, mode.name());
            stmt.execute(ddl);
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create database: " + e.getMessage());
        }
    }

    public static CreateDbMode getDbMode(Connection conn, String dbName) throws SQLException {
        if (StringUtils.isBlank((String)dbName)) {
            throw new IllegalArgumentException("Empty db name");
        }
        try (Statement stmt = conn.createStatement();){
            CreateDbMode createDbMode;
            block22: {
                ResultSet rs;
                block20: {
                    CreateDbMode createDbMode2;
                    block21: {
                        String createDb;
                        block18: {
                            CreateDbMode createDbMode3;
                            block19: {
                                rs = stmt.executeQuery(String.format("show create database `%s`", dbName));
                                try {
                                    if (!rs.next()) {
                                        throw new IllegalArgumentException(dbName + " does not exist");
                                    }
                                    createDb = rs.getString(2);
                                    if (!createDb.contains("MODE = 'drds'")) break block18;
                                    createDbMode3 = CreateDbMode.DRDS;
                                    if (rs == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    if (rs != null) {
                                        try {
                                            rs.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                rs.close();
                            }
                            return createDbMode3;
                        }
                        if (!createDb.contains(" MODE = 'auto'")) break block20;
                        createDbMode2 = CreateDbMode.AUTO;
                        if (rs == null) break block21;
                        rs.close();
                    }
                    return createDbMode2;
                }
                createDbMode = CreateDbMode.MYSQL;
                if (rs == null) break block22;
                rs.close();
            }
            return createDbMode;
        }
    }

    public static int getDnCount(BenchmarkDbInfo dbInfo) throws SQLException {
        String sql = "SHOW STORAGE WHERE INST_KIND='MASTER'";
        try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)dbInfo);){
            int n;
            block30: {
                Statement stmt = conn.createStatement();
                try {
                    int dnCount = 0;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        while (rs.next()) {
                            ++dnCount;
                        }
                    }
                    catch (SQLException e) {
                        sql = "SHOW STORAGE";
                        dnCount = 0;
                        try (ResultSet rs2 = stmt.executeQuery(sql);){
                            while (rs2.next()) {
                                if (!StringUtils.equalsIgnoreCase((String)rs2.getString("INST_KIND"), (String)"MASTER")) continue;
                                ++dnCount;
                            }
                        }
                    }
                    if (dnCount == 0) {
                        throw new RuntimeException("failed to get dn count");
                    }
                    n = dnCount;
                    if (stmt == null) break block30;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return n;
        }
    }

    public static void setVarBeforeLoadData(BenchmarkDbInfo benchmarkDbInfo, CreateDbMode dbMode) {
        if (dbMode == CreateDbMode.AUTO) {
            JdbcUtil.execSqls((BenchmarkDbInfo)benchmarkDbInfo, (List[])new List[]{BEFORE_LOAD_DATA_SQL_LIST, AUTO_MODE_BEFORE_LOAD_DATA_SQL_LIST});
        } else {
            JdbcUtil.execSqls((BenchmarkDbInfo)benchmarkDbInfo, (List[])new List[]{BEFORE_LOAD_DATA_SQL_LIST});
        }
    }

    public static void setVarAfterLoadData(BenchmarkDbInfo benchmarkDbInfo, CreateDbMode dbMode) throws SQLException {
        if (dbMode == CreateDbMode.AUTO) {
            JdbcUtil.execSqls((BenchmarkDbInfo)benchmarkDbInfo, (List[])new List[]{AFTER_LOAD_DATA_SQL_LIST, AUTO_MODE_AFTER_LOAD_DATA_SQL_LIST});
        } else {
            JdbcUtil.execSqls((BenchmarkDbInfo)benchmarkDbInfo, (List[])new List[]{AFTER_LOAD_DATA_SQL_LIST});
        }
    }

    public static void execSqls(BenchmarkDbInfo benchmarkDbInfo, List<String> ... sqlList) {
        try (Connection conn = JdbcUtil.getDbConnection((BenchmarkDbInfo)benchmarkDbInfo);
             Statement stmt = conn.createStatement();){
            for (List<String> list : sqlList) {
                for (String sql : list) {
                    try {
                        stmt.execute(sql);
                        log.info(sql);
                    }
                    catch (SQLException e) {
                        log.warn("Failed to exec: " + sql, (Throwable)e);
                    }
                }
            }
        }
        catch (SQLException e) {
            log.warn(e.getMessage());
        }
    }

    public static void close(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

