/*
 * Decompiled with CFR 0.152.
 */
import cmd.BaseOperateCommand;
import com.alibaba.druid.pool.DruidDataSource;
import datasource.DataSourceConfig;
import datasource.DruidSource;
import exec.BaseExecutor;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchTool {
    private static final Logger logger = LoggerFactory.getLogger(BatchTool.class);
    private DruidDataSource druid;
    private static final BatchTool instance = new BatchTool();

    private BatchTool() {
        Runtime.getRuntime().addShutdownHook(new Thread(this::destroy));
    }

    public static BatchTool getInstance() {
        return instance;
    }

    public void initDatasource(DataSourceConfig dataSourceConfig) throws SQLException {
        logger.info("db connection info: {}", (Object)dataSourceConfig);
        DruidSource.setDataSourceConfig(dataSourceConfig);
        this.druid = DruidSource.getInstance();
        this.druid.init();
        logger.info("Connect to database successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doBatchOp(BaseOperateCommand command, DataSourceConfig dataSourceConfig) {
        logger.info("Start batch operation...");
        commandExecutor.preCheck();
        try (BaseExecutor commandExecutor = BaseExecutor.getExecutor(command, dataSourceConfig, this.druid);){
            long startTime = System.currentTimeMillis();
            commandExecutor.execute();
            long endTime = System.currentTimeMillis();
            logger.info("Time elapsed: {} s", (Object)Float.valueOf((float)(endTime - startTime) / 1000.0f));
        }
    }

    private void destroy() {
        if (this.druid != null) {
            this.druid.close();
        }
    }
}

